/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.xml.utils.togoate;

import com.thegoate.Goate;
import com.thegoate.utils.togoate.ToGoateUtil;
import com.thegoate.utils.togoate.ToGoateUtility;
import com.thegoate.xml.XmlHelper;
import com.thegoate.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ToGoateUtil
public class XmlToGoate
extends XmlUtil
implements ToGoateUtility {
    Goate result;
    boolean autoIncrement = true;

    public XmlToGoate(Object val) {
        super(val);
        this.takeActionOn = val;
        this.nested = null;
    }

    @Override
    protected Object processNested(Object subContainer) {
        return subContainer;
    }

    @Override
    public ToGoateUtility autoIncrement(boolean increment) {
        this.autoIncrement = increment;
        return this;
    }

    @Override
    public Goate convert() {
        Goate o = new Goate();
        try {
            o = this.takeActionOn instanceof Document ? this.processXml((Document)this.takeActionOn) : this.processXml("" + this.takeActionOn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    public Goate processXml(String xml) throws Exception {
        Goate o = new Goate();
        try {
            Document xmlDoc = XmlHelper.generateDocument(xml);
            o = this.processXml(xmlDoc);
        }
        catch (Exception e) {
            throw new Exception("failed to load xml: " + e);
        }
        return o;
    }

    public Goate processXml(Document xmlDoc) {
        NodeList nodes = xmlDoc.getChildNodes();
        return this.processChildNodes(nodes, "");
    }

    private Goate processChildNodes(NodeList nodes, String preLabel) {
        Goate nodeInformation = XmlHelper.buildNodeListInformation(nodes);
        Goate o = new Goate().autoIncrement(this.autoIncrement);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String label = preLabel + (preLabel.equals("") ? "" : ".") + XmlHelper.generatePreLable(node.getNodeName(), nodeInformation);
            o.put(label, node.getTextContent());
            if (node.getChildNodes().getLength() <= 0) continue;
            o.merge(this.processChildNodes(node.getChildNodes(), label), false);
        }
        return o;
    }
}

