/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.rest;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.rest.RestSpec;

public abstract class Rest
implements RestSpec {
    protected final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    public static final String typeSeparator = "<type>";
    protected Goate headers = new Goate();
    protected Goate queryParams = new Goate();
    protected Goate urlParams = new Goate();
    protected Goate pathParams = new Goate();
    protected Goate body = new Goate();
    protected Goate custom = new Goate();
    protected Object config = null;
    protected String baseURL = "";
    protected int timeout = 15;
    protected boolean logAll = true;
    public static final String MP_ID_NOT_SET = "_mp_id_not_set";
    BODY bodyFormat = BODY.raw;

    @Override
    public boolean doLog() {
        return this.logAll;
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public RestSpec baseUri(String uri) {
        return this.baseURL(uri);
    }

    @Override
    public RestSpec baseURL(String url) {
        this.baseURL = url;
        return this;
    }

    @Override
    public RestSpec enableLog() {
        this.logAll = true;
        return this;
    }

    @Override
    public RestSpec disableLog() {
        this.logAll = false;
        return this;
    }

    @Override
    public RestSpec headers(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.header(key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec header(String key, Object value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public RestSpec queryParams(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.queryParam(key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec queryParam(String key, Object value) {
        this.queryParams.put(key, value);
        return this;
    }

    @Override
    public RestSpec urlParams(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.urlParam(key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec urlParam(String key, Object value) {
        this.urlParams.put(key, value);
        return this;
    }

    @Override
    public RestSpec pathParams(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.pathParam(key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec pathParam(String key, Object value) {
        this.pathParams.put(key, value);
        return this;
    }

    @Override
    public RestSpec bodyAsFormData() {
        this.bodyFormat = BODY.form;
        return this;
    }

    @Override
    public RestSpec bodyAsFormUrlencodedData() {
        this.bodyFormat = BODY.urlencoded;
        return this;
    }

    @Override
    public RestSpec bodyAsRawData() {
        this.bodyFormat = BODY.raw;
        return this;
    }

    @Override
    public RestSpec bodyAsMultipartFormData() {
        this.bodyFormat = BODY.multipart;
        return this;
    }

    @Override
    public RestSpec bodyAsBinaryData() {
        this.bodyFormat = BODY.binary;
        return this;
    }

    @Override
    public RestSpec formData(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.formData(key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec formData(String key, Object value) {
        this.bodyFormat = BODY.form;
        return this.body(this.bodyFormat, key, value);
    }

    @Override
    public RestSpec formUrlencodedData(String key, Object value) {
        this.bodyFormat = BODY.urlencoded;
        return this.body(this.bodyFormat, key, value);
    }

    @Override
    public RestSpec binaryBody(Object value) {
        this.bodyFormat = BODY.binary;
        return this.body(value);
    }

    @Override
    public RestSpec rawBody(Object value) {
        this.bodyFormat = BODY.raw;
        return this.body(value);
    }

    @Override
    public RestSpec multipartData(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                this.multipartFormData(key.isEmpty() ? "_mp_id_not_set##" : key, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec multipartFormData(Object value) {
        return this.multipartFormData("_mp_id_not_set##", value);
    }

    @Override
    public RestSpec multipartFormData(String key, Object value) {
        return this.multipartFormData(key, value, null);
    }

    @Override
    public RestSpec multipartFormData(String key, Object value, String contentType) {
        this.bodyFormat = BODY.multipart;
        if (contentType != null) {
            key = typeSeparator + contentType;
        }
        return this.body(this.bodyFormat, key, value);
    }

    @Override
    public RestSpec customData(Goate data) {
        if (data != null) {
            for (String key : data.keys()) {
                String keyC = "" + data.get("_cust_key:" + key, (Object)key);
                this.custom.put(keyC, data.get(key));
                this.processCustomData(keyC, data.get(key));
            }
        }
        return this;
    }

    @Override
    public RestSpec customData(Enum key, Object value) {
        this.custom.put(key.name(), value);
        return this.processCustomData(key, value);
    }

    @Override
    public RestSpec binaryBodyData(Object value) {
        this.bodyFormat = BODY.binary;
        return this.body(value);
    }

    @Override
    public RestSpec body(Object value) {
        return this.body(this.bodyFormat, "body", value);
    }

    @Override
    public RestSpec body(Enum type, String key, Object value) {
        ((Goate)this.body.get(type.name(), (Object)new Goate(), false, Goate.class)).put(key, value);
        return this;
    }

    @Override
    public Goate getQueryParameters() {
        return this.queryParams;
    }

    @Override
    public Goate getURLParameters() {
        return this.urlParams;
    }

    @Override
    public Goate getPathParameters() {
        return this.pathParams;
    }

    @Override
    public Goate getHeaders() {
        return this.headers;
    }

    @Override
    public Goate getBody() {
        return this.body;
    }

    @Override
    public RestSpec timeout(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
        return this;
    }

    @Override
    public RestSpec configure(Object config) {
        this.config = config;
        return this;
    }

    @Override
    public Object getConfig() {
        return this.config;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public static enum BODY {
        form,
        urlencoded,
        raw,
        binary,
        multipart;

    }
}

