/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.rest;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.rest.staff.ApiEmployee;
import com.thegoate.staff.GoateJob;
import java.lang.reflect.InvocationTargetException;

public class RestCall<T> {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    public static final String ENABLE_LOG = "_goate_rest_log_enabled_";
    protected Goate definition = new Goate();

    public RestCall<T> disableLog() {
        this.definition.put(ENABLE_LOG, (Object)false);
        return this;
    }

    public RestCall<T> enableLog() {
        this.definition.put(ENABLE_LOG, (Object)true);
        return this;
    }

    public RestCall<T> clear() {
        this.definition = new Goate();
        return this;
    }

    public RestCall<T> baseURL(String url) {
        this.definition.put("base url", (Object)url);
        return this;
    }

    public RestCall<T> security(String security) {
        this.definition.put("security", (Object)security);
        return this;
    }

    public RestCall<T> timeout(int timeout) {
        this.definition.put("rest.timeout", (Object)timeout);
        return this;
    }

    public RestCall<T> customParam(String key, String param) {
        this.definition.put("custom params.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> multipart(String key, Object param, String contentType) {
        if (contentType != null) {
            key = key + "<type>" + contentType;
        }
        return this.multipart(key, param);
    }

    public RestCall<T> multipart(String key, Object param) {
        this.definition.put("multipart##", (Object)(key + ":=o::_goate_mp-" + this.paramObjectName(param)));
        this.definition.put("_goate_mp-" + this.paramObjectName(param), param);
        return this;
    }

    public RestCall<T> formParam(String key, String param) {
        this.definition.put("form params.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> pathParam(String key, String param) {
        this.definition.put("path params.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> queryParam(String key, String param) {
        this.definition.put("query params.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> queryParam(String key, Object param) {
        this.definition.put("query params.##", (Object)(key + ":=o::_goate_qp-" + this.paramObjectName(param)));
        this.definition.put("_goate_qp-" + this.paramObjectName(param), param);
        return this;
    }

    public RestCall<T> urlParam(String key, String param) {
        this.definition.put("url params.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> header(String key, String param) {
        this.definition.put("headers.##", (Object)(key + ":=" + param));
        return this;
    }

    public RestCall<T> body(Object body) {
        this.definition.put("body", body);
        return this;
    }

    public RestCall<T> configure(Object config) {
        this.definition.put("config", config);
        return this;
    }

    public T get(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("get");
    }

    public T put(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("put");
    }

    public T post(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("post");
    }

    public T patch(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("patch");
    }

    public T delete(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("delete");
    }

    public T head(String endpoint) {
        this.definition.put("end point", (Object)endpoint);
        return this.execute("head");
    }

    protected String paramObjectName(Object param) {
        String name = "" + param;
        return name.replace(",", ";");
    }

    private T execute(String method) {
        this.definition.put("method", (Object)method);
        AnnotationFactory af = new AnnotationFactory();
        Object result = null;
        try {
            ApiEmployee worker = (ApiEmployee)((Object)af.annotatedWith(GoateJob.class).find((Object)method).using("jobs").build());
            worker.init(this.definition);
            result = worker.work();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.LOG.error("Barn API Init", "problem finding something to execute a " + method + "\nmake sure you have an implementation library included.", (Throwable)e);
        }
        return (T)result;
    }
}

