/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.rest.staff;

import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.rest.RestSpec;
import com.thegoate.rest.annotation.GoateRest;
import com.thegoate.staff.Employee;
import java.lang.reflect.InvocationTargetException;

public abstract class ApiEmployee<T>
extends Employee<T> {
    RestSpec rest = null;

    public void logRequest() {
        if (this.rest != null) {
            this.rest.logSpec();
        }
    }

    public Employee init() {
        String security = "" + this.definition.get("security", (Object)"none");
        try {
            this.rest = this.findAndBuildRestSpec(security);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.LOG.error("failed to find a valid rest implementation for : " + security + "\n" + e.getMessage());
        }
        return this;
    }

    protected RestSpec findAndBuildRestSpec(String security) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        RestSpec spec = null;
        AnnotationFactory af = new AnnotationFactory();
        spec = (RestSpec)af.annotatedWith(GoateRest.class).find((Object)security).using("security").build();
        if (spec != null) {
            spec.baseURL((String)this.definition.get("base url", null, true, String.class));
            spec.headers(this.definition.filterAndSplitKeyValuePairs("headers."));
            spec.urlParams(this.definition.filterAndSplitKeyValuePairs("url params."));
            spec.queryParams(this.definition.filterAndSplitKeyValuePairs("query params."));
            spec.pathParams(this.definition.filterAndSplitKeyValuePairs("path params."));
            if (this.definition.get("body") != null) {
                spec.body(this.definition.get("body"));
            }
            spec.formData(this.definition.filterAndSplitKeyValuePairs("form params."));
            spec.multipartData(this.definition.filterAndSplitKeyValuePairs("multipart"));
            spec.customData(this.definition.filterAndSplitKeyValuePairs("custom params."));
            spec.timeout(Integer.parseInt("" + this.definition.get("rest.timeout", (Object)15)));
            spec.configure(this.definition.get("config", null));
            spec.config();
            if (((Boolean)this.definition.get("_goate_rest_log_enabled_", (Object)true, Boolean.class)).booleanValue()) {
                spec.enableLog();
            } else {
                spec.disableLog();
            }
        }
        return spec;
    }

    public String[] detailedScrub() {
        String[] scrub = new String[]{"base url", "end point", "method", "headers", "url params", "query params", "path params", "body", "form params", "multipart", "custom params", "security"};
        return scrub;
    }
}

