/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.rest.assured;

import com.github.dzieciou.testing.curl.CurlLoggingRestAssuredConfigFactory;
import com.github.dzieciou.testing.curl.Options;
import com.github.dzieciou.testing.curl.Platform;
import com.thegoate.Goate;
import com.thegoate.annotations.IsDefault;
import com.thegoate.logging.BleatBox;
import com.thegoate.rest.Rest;
import com.thegoate.rest.RestSpec;
import com.thegoate.rest.annotation.GoateRest;
import com.thegoate.rest.assured.RASpec;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

@GoateRest
@IsDefault
public class RestAssured
extends Rest
implements RASpec {
    RequestSpecification specification = null;
    Response response = null;

    public RestAssured() {
        this.specification = RestAssured.init(io.restassured.RestAssured.given(), this);
    }

    public RestAssured(RequestSpecification specification) {
        this.specification = RestAssured.init(specification, this);
    }

    public static RequestSpecification init(RequestSpecification specification, RASpec spec) {
        specification = specification == null ? io.restassured.RestAssured.given() : specification;
        RestAssuredConfig rac = spec.getConfig() == null ? new RestAssuredConfig() : (RestAssuredConfig)spec.getConfig();
        PrintStream streamer = RestAssured.getPrintStream(spec.getLog());
        LogConfig lc = new LogConfig(streamer, true);
        SSLConfig sslc = new SSLConfig().allowAllHostnames().relaxedHTTPSValidation();
        rac = rac.sslConfig(sslc);
        rac = rac.logConfig(lc);
        rac = spec.getHeaders().keys().toArray().length > 0 ? rac.headerConfig(HeaderConfig.headerConfig().overwriteHeadersWithName("Content-Type", spec.getHeaders().keysArray())) : rac.headerConfig(HeaderConfig.headerConfig().overwriteHeadersWithName("Content-Type", new String[0]));
        int timeout = spec.getTimeout();
        rac = rac.httpClient(HttpClientConfig.httpClientConfig().setParam("CONNECTION_MANAGER_TIMEOUT", (Object)(timeout * 1000)));
        rac = rac.encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false));
        Options options = Options.builder().targetPlatform(Platform.UNIX).build();
        rac = CurlLoggingRestAssuredConfigFactory.updateConfig((RestAssuredConfig)rac, (Options)options);
        return specification.config(rac);
    }

    public static RequestSpecification build(RASpec spec) {
        RequestSpecification mySpec = spec.getSpec();
        if (mySpec != null) {
            mySpec.baseUri(spec.getBaseURL());
            RestAssured.setHeaders(mySpec, spec.getHeaders());
            RestAssured.setURLParameters(mySpec, spec.getURLParameters());
            RestAssured.setQueryParameters(mySpec, spec.getQueryParameters());
            RestAssured.setPathParameters(mySpec, spec.getPathParameters());
            RestAssured.setBody(mySpec, spec.getBody());
            if (spec.doLog()) {
                mySpec.log().all();
                spec.getLog().flush();
            }
        }
        return mySpec;
    }

    public RestSpec config() {
        RestAssured.init(this.specification, this);
        return this;
    }

    @Override
    public BleatBox getLog() {
        return this.LOG;
    }

    public static PrintStream getPrintStream(final BleatBox log) {
        OutputStream output = new OutputStream(){
            BleatBox logger;
            private StringBuilder myStringBuilder;
            {
                this.logger = log;
                this.myStringBuilder = new StringBuilder();
            }

            @Override
            public void write(int b) throws IOException {
                this.myStringBuilder.append((char)b);
            }

            @Override
            public void flush() {
                this.logger.infoBuffer("RestAssured Response", this.myStringBuilder.toString());
                this.myStringBuilder = new StringBuilder();
            }
        };
        PrintStream stream = new PrintStream(output, true);
        return stream;
    }

    protected static void setHeaders(RequestSpecification spec, Goate headers) {
        if (headers != null && spec != null) {
            for (String key : headers.keys()) {
                spec.header(key, headers.get(key), new Object[0]);
            }
        }
    }

    protected static void setURLParameters(RequestSpecification spec, Goate params) {
        if (params != null && spec != null) {
            for (String key : params.keys()) {
                spec.param(key, new Object[]{params.get(key)});
            }
        }
    }

    protected static void setQueryParameters(RequestSpecification spec, Goate params) {
        if (params != null && spec != null) {
            for (String key : params.keys()) {
                spec.queryParam(key, new Object[]{params.get(key)});
            }
        }
    }

    protected static void setPathParameters(RequestSpecification spec, Goate params) {
        if (params != null && spec != null) {
            for (String key : params.keys()) {
                spec.pathParam(key, params.get(key));
            }
        }
    }

    protected static void setBody(RequestSpecification spec, Goate body) {
        if (spec != null && body != null) {
            for (String key : body.keys()) {
                Goate b = (Goate)body.get(key);
                if (b == null) continue;
                for (String id : b.keys()) {
                    String[] keyParts = id.split("<type>");
                    String type = null;
                    String idkey = keyParts[0];
                    if (keyParts.length > 1) {
                        type = keyParts[1];
                    }
                    if (key.equals(Rest.BODY.urlencoded.name()) || key.equals(Rest.BODY.form.name())) {
                        spec.formParam(idkey, new Object[]{b.get(id)});
                        continue;
                    }
                    if (key.startsWith(Rest.BODY.multipart.name())) {
                        if (idkey.equals("_mp_id_not_set")) {
                            spec.multiPart((File)b.get(id));
                            continue;
                        }
                        if (b.get(id) instanceof File) {
                            if (type != null) {
                                spec.multiPart(idkey, (File)b.get(id), type);
                                continue;
                            }
                            spec.multiPart(idkey, (File)b.get(id));
                            continue;
                        }
                        if (b.get(id) instanceof String) {
                            if (type != null) {
                                spec.multiPart(idkey, "" + b.get(id), type);
                                continue;
                            }
                            spec.multiPart(idkey, "" + b.get(id));
                            continue;
                        }
                        if (type != null) {
                            spec.multiPart(idkey, b.get(id), type);
                            continue;
                        }
                        spec.multiPart(idkey, b.get(id));
                        continue;
                    }
                    spec.body(b.get(id));
                }
            }
        }
    }

    public Object response() {
        return this.response;
    }

    public RestSpec processCustomData(String key, Object value) {
        return this;
    }

    public RestSpec logSpec() {
        if (this.specification != null) {
            this.specification.log().all();
        }
        return this;
    }

    public RestSpec processCustomData(Enum key, Object value) {
        return this;
    }

    public Object get(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.get(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    public Object put(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.put(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    public Object post(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.post(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    public Object delete(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.delete(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    public Object patch(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.patch(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    public Object head(String endpoint) {
        this.specification = RestAssured.build(this);
        this.response = (Response)this.specification.head(endpoint, new Object[0]);
        this.log(this.response);
        return this.response;
    }

    protected void log(Response response) {
        if (this.doLog()) {
            this.LOG.debug("RestAssured", "response follows");
            ((ValidatableResponse)response.then()).log().all();
            this.LOG.flush();
        }
    }

    @Override
    public RequestSpecification getSpec() {
        this.specification = RestAssured.init(io.restassured.RestAssured.given(), this);
        return this.specification;
    }
}

