/*
 * Copyright (c) 2017. Eric Angeli
 *
 *  Permission is hereby granted, free of charge,
 *  to any person obtaining a copy of this software
 *  and associated documentation files (the "Software"),
 *  to deal in the Software without restriction,
 *  including without limitation the rights to use, copy,
 *  modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit
 *  persons to whom the Software is furnished to do so,
 *  subject to the following conditions:
 *
 *  The above copyright notice and this permission
 *  notice shall be included in all copies or substantial
 *  portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 *  AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */
package com.goate.selenium.dsl;

import com.goate.selenium.WebDriverBuilder;
import com.thegoate.Goate;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import org.openqa.selenium.WebDriver;

/**
 * Builds and sets the selenium web driver.
 * Created by Eric Angeli on 6/27/2017.
 */
@GoateDSL(word = "webdriver")
public class GetDriver extends DSL {
    public GetDriver(){
        super();
    }

    public GetDriver(Object value){
        super(value);
    }

    @Override
    public Object evaluate(Goate data) {
        String browser = ""+get(1,data);
        WebDriverBuilder builder = new WebDriverBuilder(browser);
        for(int i = 2; get(i, data)!=null; i++){
            String[] capability = (""+get(i, data)).split("==");
            builder.addCapability(capability[0], capability[1]);
        }
        WebDriver driver = builder.build();
        if(!key.isEmpty()){
            data.put(key,driver);
        }
        return driver;
    }
}
