/*
 * Decompiled with CFR 0.152.
 */
package com.goate.selenium;

import com.goate.selenium.Browser;
import com.goate.selenium.annotations.Driver;
import com.goate.selenium.staff.GoateDriver;
import com.goate.selenium.staff.RemoteWebDriver;
import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.WebDriver;

public class WebDriverBuilder {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    String browser = "";
    String remote = "";
    Goate dc = new Goate();

    public WebDriverBuilder(String browser) {
        this.init(browser);
    }

    public WebDriverBuilder(Browser browser) {
        this.init(browser.type());
    }

    private void init(String browser) {
        this.browser = browser;
    }

    public WebDriverBuilder isRemote(boolean remote) {
        if (remote) {
            if (!this.browser.startsWith("remote:")) {
                this.browser = "remote:" + this.browser;
            }
        } else {
            this.browser = this.browser.replace("remote:", "");
        }
        return this;
    }

    public WebDriverBuilder addCapability(String name, Object value) {
        this.dc.put(name, value);
        return this;
    }

    public WebDriver build() {
        return this.build(this.dc);
    }

    public GoateDriver buildGoateDriver() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        AnnotationFactory af = new AnnotationFactory();
        return (GoateDriver)af.annotatedWith(Driver.class).find((Object)this.browser).using("type").build();
    }

    public WebDriver build(Goate data) {
        GoateDriver driver = null;
        try {
            if (this.browser.startsWith("remote:")) {
                this.remote = this.browser.substring("remote:".length());
                this.browser = "remote";
            }
            driver = this.buildGoateDriver();
            if (!this.remote.isEmpty()) {
                ((RemoteWebDriver)driver).remote(this.remote);
            }
            for (String name : data.keys()) {
                driver.addCapability(name, data.get(name));
            }
        }
        catch (Exception e) {
            this.LOG.error("Failed to load the webdriver for: " + this.browser + "\n" + e.getMessage(), (Throwable)e);
        }
        return driver != null ? driver.build() : null;
    }
}

