/*
 * Decompiled with CFR 0.152.
 */
package com.goate.selenium.staff;

import com.goate.selenium.annotations.Driver;
import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.GoateUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;

public abstract class GoateDriver {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    OS os = this.detectOS();
    MutableCapabilities dc = this.loadCapabilities();
    boolean driverInstalled = false;
    String driverPath = "";
    String extension = "driver.exe";

    public GoateDriver() {
        this.setPathToDriver();
    }

    protected abstract MutableCapabilities loadCapabilities();

    public MutableCapabilities getDc() {
        return this.dc;
    }

    public abstract WebDriver build();

    public GoateDriver addCapability(String name, Object value) {
        if (this.dc != null) {
            this.dc.setCapability(name, value);
        } else {
            this.LOG.warn("Capabilities have not been loaded for the driver.");
        }
        return this;
    }

    protected OS detectOS() {
        OS type = null;
        String sys = System.getProperty("os.name");
        String architecture = System.getProperty("os.arch", System.getenv("ProgramFiles(x86)"));
        if (sys.contains("Windows")) {
            type = architecture == null ? OS.WIN32 : (architecture.contains("32") ? OS.WIN32 : OS.WIN64);
        } else if (sys.contains("Linux")) {
            type = architecture == null ? OS.LIN32 : (architecture.contains("32") ? OS.LIN32 : OS.LIN64);
        } else if (sys.contains("Mac")) {
            type = OS.MACOS;
        }
        return type;
    }

    protected void setPathToDriver() {
        String browser = "";
        Object path = "";
        Driver d = this.getClass().getAnnotation(Driver.class);
        if (d != null) {
            browser = d.property().isEmpty() ? d.type() : d.property();
            this.driverPath = (String)new Goate().get("driverpath", (Object)("eut::selenium." + browser + ".path,empty::"), String.class);
            if (this.driverPath.isEmpty()) {
                this.driverPath = "webdrivers/" + browser;
            }
            path = this.driverPath + "/" + this.os.path() + "/" + browser + this.os.ext(this.extension);
            path = GoateUtils.getFilePath((String)path);
            if (!browser.isEmpty()) {
                System.setProperty("webdriver." + browser + ".driver", (String)path);
            }
        }
    }

    static enum OS {
        WIN32("windows/32", true),
        WIN64("windows/64", true),
        LIN32("linux/32", false),
        LIN64("linux/64", false),
        ANDROID("android/64", false),
        IOS("ios/64", false),
        MACOS("macos/64", false);

        String path;
        boolean exe;

        private OS(String path, boolean exe) {
            this.path = path;
            this.exe = exe;
        }

        public String path() {
            return this.path;
        }

        public String ext(String extension) {
            return this.exe ? extension : extension.replace(".exe", "");
        }
    }
}

