/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.AsciiToEbcdicByteArrayConverter;
import com.thelastcheck.commons.buffer.ByteArrayConverter;
import com.thelastcheck.commons.buffer.EbcdicToAsciiByteArrayConverter;
import com.thelastcheck.commons.buffer.IllegalNullArgumentException;
import com.thelastcheck.commons.buffer.UnsupportedEncodingException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteArray
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -399296889418381603L;
    private ByteBuffer value;
    private String encoding;
    public static final String ASCII_CHARSET_NAME = "US-ASCII";
    public static final String EBCDIC_CHARSET_NAME = "IBM1047";
    private static final String SPACE = " ";
    private static Map<String, Byte> encodeMap = null;
    private static Pattern psRegexPattern = null;
    private static ByteArrayConverter bacAsciiToEbcdic = new AsciiToEbcdicByteArrayConverter();
    private static ByteArrayConverter bacEbcdicToAscii = new EbcdicToAsciiByteArrayConverter();

    public ByteArray(int size) {
        this(size, null, null);
    }

    public ByteArray(int size, String encoding) {
        this(new byte[size], encoding, null);
    }

    public ByteArray(int size, ByteOrder order) {
        this(new byte[size], null, order);
    }

    public ByteArray(int size, String encoding, ByteOrder order) {
        this(new byte[size], encoding, order);
    }

    public ByteArray(byte[] array) {
        this(array, null, null);
    }

    public ByteArray(byte[] array, ByteOrder order) {
        this(array, null, order);
    }

    public ByteArray(byte[] array, String encoding) {
        this(array, encoding, null);
    }

    public ByteArray(byte[] array, String encoding, ByteOrder order) {
        if (array == null) {
            throw new IllegalNullArgumentException();
        }
        this.value = ByteBuffer.wrap(array);
        this.encoding = encoding == null ? ASCII_CHARSET_NAME : encoding;
        if (order == null) {
            this.value.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.value.order(order);
        }
    }

    public ByteArray(ByteArray byteArray) {
        if (byteArray == null) {
            throw new IllegalNullArgumentException();
        }
        this.value = byteArray.value.duplicate();
        this.value.order(byteArray.value.order());
        this.value.clear();
        this.encoding = byteArray.encoding;
    }

    public ByteArray(ByteBuffer buffer) {
        this(buffer, null);
    }

    public ByteArray(ByteBuffer buffer, String encoding) {
        if (buffer == null) {
            throw new IllegalNullArgumentException();
        }
        this.value = buffer.duplicate();
        this.value.order(buffer.order());
        this.value.clear();
        this.encoding = encoding == null ? ASCII_CHARSET_NAME : encoding;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.value.isDirect()) {
            throw new CloneNotSupportedException("Can't clone a direct buffer");
        }
        ByteArray object = (ByteArray)super.clone();
        this.value.clear();
        byte[] bytes = new byte[this.value.remaining()];
        this.value.get(bytes);
        object.value = ByteBuffer.wrap(bytes);
        object.value.order(this.value.order());
        return object;
    }

    public ByteArray slice(int displacement, int length) {
        this.value.position(displacement).limit(displacement + length);
        ByteArray newByteArray = new ByteArray(this.value.slice(), this.encoding);
        newByteArray.setOrder(this.getOrder());
        this.value.clear();
        return newByteArray;
    }

    public ByteArray duplicate() {
        return new ByteArray(this.value, this.encoding);
    }

    public boolean testBit(int displacement, byte mask) {
        return (this.value.get(displacement) & mask) == mask;
    }

    public ByteArray setBit(int displacement, byte mask) {
        byte b = this.value.get(displacement);
        b = (byte)(b | mask);
        this.value.put(displacement, b);
        return this;
    }

    public ByteArray setBit(int displacement, byte mask, boolean b) {
        if (b) {
            this.setBit(displacement, mask);
        } else {
            this.clearBit(displacement, mask);
        }
        return this;
    }

    public ByteArray clearBit(int displacement, byte mask) {
        byte b = this.value.get(displacement);
        b = (byte)(b & 255 - (mask & 0xFF));
        this.value.put(displacement, b);
        return this;
    }

    public byte[] read(int displacement, int length) {
        byte[] tempByteArray = new byte[length];
        this.value.position(displacement);
        this.value.get(tempByteArray);
        return tempByteArray;
    }

    public int read(int displacement, byte[] bytes) {
        return this.read(displacement, bytes, 0, bytes.length);
    }

    public int read(int displacement, byte[] bytes, int offset, int length) {
        int i;
        this.value.position(displacement);
        for (i = 0; i < length && this.value.remaining() > 0; ++i) {
            bytes[offset + i] = this.value.get();
        }
        return i;
    }

    public byte readAsByte(int displacement) {
        return this.value.get(displacement);
    }

    public ByteArray readAsByteArray(int displacement, int length) {
        byte[] tempByteArray = this.read(displacement, length);
        return new ByteArray(tempByteArray, this.encoding);
    }

    public char readAsChar(int displacement) {
        char ch;
        if (this.encoding.equals(EBCDIC_CHARSET_NAME)) {
            ch = (char)bacEbcdicToAscii.convert(this.value.get(displacement));
        } else if (this.encoding.equals(ASCII_CHARSET_NAME)) {
            ch = (char)this.value.get(displacement);
        } else {
            throw new UnsupportedEncodingException();
        }
        return ch;
    }

    public char[] readAsCharArray(int displacement, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.readAsChar(displacement + i);
        }
        return chars;
    }

    public int read(int displacement, char[] chars) {
        return this.read(displacement, chars, 0, chars.length);
    }

    public int read(int displacement, char[] chars, int offset, int length) {
        int count;
        this.value.position(displacement);
        if (this.value.remaining() == 0) {
            return 0;
        }
        int n = count = length < this.value.remaining() ? length : this.value.remaining();
        if (this.encoding.equals(EBCDIC_CHARSET_NAME)) {
            for (int i = 0; i < count; ++i) {
                chars[offset + i] = (char)bacEbcdicToAscii.convert(this.value.get());
            }
        } else if (this.encoding.equals(ASCII_CHARSET_NAME)) {
            for (int i = 0; i < count; ++i) {
                chars[offset + i] = (char)this.value.get();
            }
        } else {
            throw new UnsupportedEncodingException();
        }
        return count;
    }

    public String readAsString() {
        this.value.clear();
        return this.readAsString(0, this.value.remaining());
    }

    public String readAsString(int displacement) {
        this.value.clear();
        this.value.position(displacement);
        return this.readAsString(displacement, this.value.remaining());
    }

    public String readAsString(int displacement, int length) {
        return this.readAsString(displacement, length, false);
    }

    public String readAsString(int displacement, int length, boolean nts) {
        int stringLen = length;
        if (nts) {
            int i = displacement;
            for (int j = 0; j < length; ++j) {
                if (this.value.get(i) == 0) {
                    stringLen = j;
                    break;
                }
                ++i;
            }
        }
        char[] chars = new char[stringLen];
        this.read(displacement, chars);
        return new String(chars);
    }

    public float readAsFloat(int displacement) {
        float f = this.value.getFloat(displacement);
        return f;
    }

    public double readAsDouble(int displacement) {
        double d = this.value.getDouble(displacement);
        return d;
    }

    public short readAsShort(int displacement) {
        short s = this.value.getShort(displacement);
        return s;
    }

    public int readAsInt(int displacement) {
        int i = this.value.getInt(displacement);
        return i;
    }

    public long readAsLong(int displacement) {
        long i = this.value.getLong(displacement);
        return i;
    }

    public String readPns(int displacement, int length) {
        return this.readPns(displacement, length, false);
    }

    public String readPns(int displacement, int length, boolean convertAtoF) {
        StringBuffer sb = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            byte leftNybble = (byte)((this.value.get(displacement + i) & 0xF0) >> 4);
            byte rightNybble = (byte)(this.value.get(displacement + i) & 0xF);
            char leftChar = leftNybble < 10 ? (char)(leftNybble + 48) : (convertAtoF ? this.convertAtoF(leftNybble) : (char)(leftNybble + 65 - 10));
            char rightChar = rightNybble < 10 ? (char)(rightNybble + 48) : (convertAtoF ? this.convertAtoF(rightNybble) : (char)(rightNybble + 65 - 10));
            sb.append(leftChar);
            sb.append(rightChar);
        }
        return sb.toString();
    }

    private char convertAtoF(byte nybble) {
        char convertedChar;
        byte work = (byte)(nybble - 10);
        switch (work) {
            case 0: {
                convertedChar = ' ';
                break;
            }
            case 3: {
                convertedChar = '-';
                break;
            }
            case 4: {
                convertedChar = '*';
                break;
            }
            case 5: {
                convertedChar = '*';
                break;
            }
            default: {
                convertedChar = (char)(work + 65);
            }
        }
        return convertedChar;
    }

    public ByteArray fill() {
        this.value.clear();
        return this.fill(ByteArray.getSpaceFiller(this.encoding), 0, this.value.remaining());
    }

    public ByteArray fill(byte filler) {
        this.value.clear();
        return this.fill(filler, 0, this.value.remaining());
    }

    public ByteArray fill(byte filler, int displacement, int length) {
        for (int i = displacement; i < displacement + length; ++i) {
            this.value.put(i, filler);
        }
        return this;
    }

    public ByteArray write(char[] chars, int displacement) {
        return this.write(chars, 0, chars.length, displacement);
    }

    public ByteArray write(char[] chars, int offset, int length, int displacement) {
        if (this.encoding.equals(EBCDIC_CHARSET_NAME)) {
            byte[] bytes = bacAsciiToEbcdic.convert(chars, offset, length);
            this.value.position(displacement);
            this.value.put(bytes);
        } else if (this.encoding.equals(ASCII_CHARSET_NAME)) {
            this.value.position(displacement);
            for (int i = 0; i < length; ++i) {
                this.value.put((byte)chars[offset + i]);
            }
        } else {
            throw new UnsupportedEncodingException();
        }
        return this;
    }

    public ByteArray write(ByteArray byteArray, int displacement, int length) throws ArrayIndexOutOfBoundsException {
        this.value.position(displacement);
        for (int i = 0; i < length; ++i) {
            this.value.put(byteArray.value.get(i));
        }
        return this;
    }

    public ByteArray write(ByteArray byteArray, int displacement) {
        byteArray.value.clear();
        int length = byteArray.value.remaining();
        return this.write(byteArray, displacement, length);
    }

    public ByteArray write(byte[] bytes, int displacement) {
        return this.write(bytes, 0, bytes.length, displacement);
    }

    public ByteArray write(byte[] bytes, int offset, int length, int displacement) throws ArrayIndexOutOfBoundsException {
        this.value.position(displacement);
        for (int i = 0; i < length; ++i) {
            this.value.put(bytes[offset + i]);
        }
        return this;
    }

    public ByteArray write(String s, int displacement) {
        return this.write(s, displacement, s.length(), false);
    }

    public ByteArray write(String s, int displacement, int length) {
        return this.write(s, displacement, length, false);
    }

    public ByteArray write(String s, int displacement, int length, boolean nts) {
        int dataLen = s.length();
        if (dataLen > length) {
            throw new IllegalArgumentException("Length of String exceeds the available length specified.");
        }
        char[] chars = s.toCharArray();
        this.write(chars, displacement);
        if (dataLen < length) {
            byte filler = 0;
            if (!nts) {
                filler = ByteArray.getSpaceFiller(this.encoding);
            }
            this.value.position(displacement + dataLen);
            while (dataLen < length) {
                this.value.put(filler);
                ++dataLen;
            }
        }
        return this;
    }

    public ByteArray write(short s, int displacement) {
        this.value.putShort(displacement, s);
        return this;
    }

    public ByteArray write(char c, int displacement) {
        if (this.encoding.equals(EBCDIC_CHARSET_NAME)) {
            this.value.put(displacement, bacAsciiToEbcdic.convert(c));
        } else if (this.encoding.equals(ASCII_CHARSET_NAME)) {
            this.value.put(displacement, (byte)c);
        } else {
            throw new UnsupportedEncodingException();
        }
        return this;
    }

    public ByteArray write(byte b, int displacement) {
        this.value.put(displacement, b);
        return this;
    }

    public ByteArray write(int i, int displacement) {
        this.value.putInt(displacement, i);
        return this;
    }

    public ByteArray write(long i, int displacement) {
        this.value.putLong(displacement, i);
        return this;
    }

    public ByteArray write(float f, int displacement) {
        this.value.putFloat(displacement, f);
        return this;
    }

    public ByteArray write(double d, int displacement) {
        this.value.putDouble(displacement, d);
        return this;
    }

    public ByteArray writeAsPs(String s, int displacement, int length) {
        Matcher matcher = psRegexPattern.matcher(s = s.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Value:" + s + " has illegal character values for a packed field.");
        }
        int sign = 70;
        if (s.length() > 0) {
            if (s.charAt(s.length() - 1) == '+' || s.charAt(0) == '+') {
                sign = 67;
                s = s.replaceAll("\\+", "");
            } else if (s.charAt(s.length() - 1) == '-' || s.charAt(0) == '-') {
                sign = 68;
                s = s.replaceAll("-", "");
            }
        }
        s = s + (char)sign;
        this.writeAsPns(s, displacement, length, '0');
        return this;
    }

    public ByteArray writeAsPns(String s, int displacement, int length) {
        return this.writeAsPns(s, displacement, length, ' ');
    }

    public ByteArray writeAsPns(String s, int displacement, int length, char filler) {
        String work = s;
        int numNybbles = length * 2;
        if (work.length() > numNybbles) {
            throw new IllegalArgumentException("Number of digits for PNS field exceeds available buffer. Value:" + s + "\tField Length:" + length);
        }
        if (work.length() < numNybbles) {
            int extraNybbles = numNybbles - work.length();
            StringBuffer sb = new StringBuffer(numNybbles);
            for (int i = 0; i < extraNybbles; ++i) {
                sb.append(filler);
            }
            sb.append(work);
            work = sb.toString();
        }
        String normalValue = work.toUpperCase();
        int i = 0;
        for (int j = 0; j < length; ++j) {
            char leftChar = normalValue.charAt(i++);
            char rightChar = normalValue.charAt(i++);
            byte leftNybble = ByteArray.convertCharToNybble(leftChar);
            byte rightNybble = ByteArray.convertCharToNybble(rightChar);
            this.value.put(displacement + j, (byte)(leftNybble << 4 | rightNybble));
        }
        return this;
    }

    private static byte convertCharToNybble(char fromChar) {
        int ch = fromChar;
        if (ch == 32) {
            ch = 65;
        }
        if (ch == 45) {
            ch = 68;
        }
        if (ch == 42) {
            ch = 70;
        }
        if (!(ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70)) {
            throw new IllegalArgumentException("Value values for PNS field are 0-9, A-F");
        }
        byte nybble = ch < 65 ? (byte)(ch - 48) : (byte)(ch - 65 + 10);
        return nybble;
    }

    public static byte getSpaceFiller(String encoding) {
        encoding = encoding.toUpperCase();
        byte filler = 0;
        Byte b = encodeMap.get(encoding);
        if (b != null) {
            filler = b;
        } else {
            try {
                filler = SPACE.getBytes(encoding)[0];
            }
            catch (java.io.UnsupportedEncodingException e1) {
                filler = SPACE.getBytes()[0];
            }
            encodeMap.put(encoding, new Byte(filler));
        }
        return filler;
    }

    public static ByteArray valueOf(String string) {
        ByteArray ba = new ByteArray(string.length());
        ba.write(string, 0);
        return ba;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ByteArray) {
            return ByteArray.equalTo(this, (ByteArray)anObject);
        }
        return false;
    }

    public static boolean equalTo(ByteArray a, ByteArray b) {
        if (a == null || b == null) {
            throw new IllegalNullArgumentException();
        }
        if (a == b) {
            return true;
        }
        a.value.clear();
        b.value.clear();
        if (a.value.remaining() != b.value.remaining()) {
            return false;
        }
        int length = a.value.remaining();
        boolean match = true;
        for (int i = 0; i < length; ++i) {
            if (a.value.get() == b.value.get()) continue;
            match = false;
            break;
        }
        a.value.rewind();
        b.value.rewind();
        return match;
    }

    public boolean equalSame(byte b) {
        this.value.clear();
        return this.equalSame(b, 0, this.value.remaining());
    }

    public boolean equalSame(byte b, int displacement, int length) {
        int i = 0;
        int j = displacement;
        while (i < length) {
            if (this.value.get(j) != b) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int getLength() {
        this.value.clear();
        return this.value.remaining();
    }

    public boolean hasArray() {
        return this.value.hasArray();
    }

    public UnderlyingArray getArray() {
        byte[] bytes = this.value.array();
        int offset = this.value.arrayOffset();
        int length = this.value.capacity();
        return new UnderlyingArray(bytes, offset, length);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.value.capacity()];
        this.value.clear();
        this.value.get(bytes);
        return bytes;
    }

    @Deprecated
    public byte[] getByteArray() {
        return this.getArray().value;
    }

    public ByteArray setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ByteArray setOrder(ByteOrder order) {
        this.value.order(order);
        return this;
    }

    public ByteOrder getOrder() {
        return this.value.order();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer newByteBuffer = this.value.duplicate();
        newByteBuffer.order(this.value.order());
        newByteBuffer.clear();
        return newByteBuffer;
    }

    static {
        encodeMap = Collections.synchronizedMap(new HashMap());
        byte filler = 0;
        try {
            filler = SPACE.getBytes(ASCII_CHARSET_NAME)[0];
            encodeMap.put(ASCII_CHARSET_NAME, new Byte(filler));
            filler = SPACE.getBytes(EBCDIC_CHARSET_NAME)[0];
            encodeMap.put(EBCDIC_CHARSET_NAME, new Byte(filler));
        }
        catch (java.io.UnsupportedEncodingException e1) {
            // empty catch block
        }
        String regex = "(\\A[\\x2D\\x2B]?\\d*\\z)|(\\A\\d*[\\x2D\\x2B]?\\z)";
        psRegexPattern = Pattern.compile(regex);
    }

    public static class UnderlyingArray {
        public final byte[] value;
        public final int offset;
        public final int length;

        private UnderlyingArray(byte[] value, int offset, int length) {
            this.value = value;
            this.offset = offset;
            this.length = length;
        }
    }
}

