/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.RecordFilter;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x937.records.X937BundleControlRecord;
import com.thelastcheck.io.x937.records.X937CashLetterControlRecord;
import com.thelastcheck.io.x937.records.X937CheckDetailRecord;
import com.thelastcheck.io.x937.records.X937FileControlRecord;
import com.thelastcheck.io.x937.records.X937ReturnRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlTotalsRecordFilter
implements RecordFilter {
    private static Logger log = LoggerFactory.getLogger(ControlTotalsRecordFilter.class);
    private int totalRecordCount;
    private int bundleItemCount;
    private long bundleTotalAmount;
    private long bundleMicrValidAmount;
    private int bundleImagesCount;
    private int cashLetterItemCount;
    private int cashLetterImagesCount;
    private long cashLetterTotalAmount;
    private int fileItemCount;
    private long fileTotalAmount;
    private int cashLetterBundleCount;
    private int fileCashLetterCount;

    public Record filter(Record record) {
        X9Record x9Record = (X9Record)record;
        ++this.totalRecordCount;
        switch (x9Record.recordType()) {
            case 25: {
                X937CheckDetailRecord cdr = (X937CheckDetailRecord)x9Record;
                ++this.bundleItemCount;
                long itemAmount = 0L;
                try {
                    itemAmount = cdr.itemAmountAsLong();
                }
                catch (InvalidDataException e) {
                    log.warn("Invalid item amount, cannot add to bundle total amount: " + e.getLocalizedMessage());
                }
                this.bundleTotalAmount += itemAmount;
                if (!cdr.MICRValidIndicator().equals("1")) break;
                this.bundleMicrValidAmount += itemAmount;
                break;
            }
            case 31: {
                X937ReturnRecord rr = (X937ReturnRecord)x9Record;
                ++this.bundleItemCount;
                try {
                    this.bundleTotalAmount += rr.itemAmountAsLong();
                }
                catch (InvalidDataException e) {
                    log.warn("Invalid item amount, cannot add to bundle total amount: " + e.getLocalizedMessage());
                }
                break;
            }
            case 52: {
                ++this.bundleImagesCount;
                break;
            }
            case 70: {
                X937BundleControlRecord bcr = (X937BundleControlRecord)x9Record;
                bcr.bundleTotalAmount(this.bundleTotalAmount);
                bcr.itemsWithinBundleCount(this.bundleItemCount);
                bcr.MICRValidTotalAmount(this.bundleMicrValidAmount);
                bcr.imagesWithinBundleCount(this.bundleImagesCount);
                this.cashLetterItemCount += this.bundleItemCount;
                this.cashLetterImagesCount += this.bundleImagesCount;
                this.cashLetterTotalAmount += this.bundleTotalAmount;
                ++this.cashLetterBundleCount;
                this.bundleItemCount = 0;
                this.bundleImagesCount = 0;
                this.bundleTotalAmount = 0L;
                this.bundleMicrValidAmount = 0L;
                break;
            }
            case 90: {
                X937CashLetterControlRecord clcr = (X937CashLetterControlRecord)x9Record;
                clcr.cashLetterTotalAmount(this.cashLetterTotalAmount);
                clcr.itemsWithinCashletterCount(this.cashLetterItemCount);
                clcr.imagesWithinCashLetterCount(this.cashLetterImagesCount);
                clcr.bundleCount(this.cashLetterBundleCount);
                this.fileItemCount += this.cashLetterItemCount;
                this.fileTotalAmount += this.cashLetterTotalAmount;
                ++this.fileCashLetterCount;
                this.cashLetterTotalAmount = 0L;
                this.cashLetterItemCount = 0;
                this.cashLetterImagesCount = 0;
                this.cashLetterBundleCount = 0;
                break;
            }
            case 99: {
                X937FileControlRecord fcr = (X937FileControlRecord)x9Record;
                fcr.fileTotalAmount(this.fileTotalAmount);
                fcr.totalItemCount(this.fileItemCount);
                fcr.cashLetterCount(this.fileCashLetterCount);
                fcr.totalRecordCount(this.totalRecordCount);
                break;
            }
        }
        return record;
    }
}

