/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.RecordFilter;
import com.thelastcheck.io.x9.X9Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordCountRecordFilter
implements RecordFilter {
    private Logger log = LoggerFactory.getLogger(RecordCountRecordFilter.class);
    private int[] recordCounters = new int[100];

    public Record filter(Record record) {
        this.countRecord((X9Record)record);
        return record;
    }

    private void countRecord(X9Record record) {
        int recordType;
        int n = recordType = record.recordType();
        this.recordCounters[n] = this.recordCounters[n] + 1;
        this.recordCounters[0] = this.recordCounters[0] + 1;
    }

    public int[] getRecordCounters() {
        return this.recordCounters;
    }

    public void logRecordCounters() {
        for (int i = 1; i < this.recordCounters.length; ++i) {
            if (this.recordCounters[i] <= 0) continue;
            this.log.info(String.format("Record type [%02d]) count: %7d", i, this.recordCounters[i]));
        }
        this.log.info("------------------------");
        this.log.info(String.format("     Record total count: %7d", this.recordCounters[0]));
    }
}

