/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.google.common.collect.Lists;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.exception.RecordReaderException;
import com.thelastcheck.io.x9.X9InputStreamRecordReader;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x9.parser.X937CheckDetailGraph;
import com.thelastcheck.io.x9.parser.X937ImageViewRecords;
import com.thelastcheck.io.x9.parser.X937RecordGraphRecordFilter;
import com.thelastcheck.io.x937.records.X937BundleControlRecord;
import com.thelastcheck.io.x937.records.X937BundleHeaderRecord;
import com.thelastcheck.io.x937.records.X937CashLetterControlRecord;
import com.thelastcheck.io.x937.records.X937CashLetterHeaderRecord;
import com.thelastcheck.io.x937.records.X937CheckDetailAddendumARecord;
import com.thelastcheck.io.x937.records.X937CheckDetailAddendumBRecord;
import com.thelastcheck.io.x937.records.X937CheckDetailAddendumCRecord;
import com.thelastcheck.io.x937.records.X937CheckDetailRecord;
import com.thelastcheck.io.x937.records.X937FileControlRecord;
import com.thelastcheck.io.x937.records.X937FileHeaderRecord;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class X9InputStreamCheckDetailReader
implements Iterable<X937CheckDetailGraph>,
Closeable {
    private X9InputStreamRecordReader reader;
    private X937RecordGraphRecordFilter graphFilter;
    private Record previousRecord;
    private X937CheckDetailGraph cachedRecord;

    public X9InputStreamCheckDetailReader(InputStream inputStream) {
        this(inputStream, false);
    }

    public X9InputStreamCheckDetailReader(X9InputStreamRecordReader reader) {
        this.reader = reader;
        this.graphFilter = new X937RecordGraphRecordFilter();
    }

    public X9InputStreamCheckDetailReader(InputStream inputStream, boolean skipInvalidRecords) {
        this.reader = this.createInputStreamReader(inputStream, skipInvalidRecords);
        this.graphFilter = new X937RecordGraphRecordFilter();
    }

    public X937CheckDetailGraph readNextCheckDetail() throws IOException {
        if (this.cachedRecord != null) {
            X937CheckDetailGraph record = this.cachedRecord;
            this.cachedRecord = null;
            return record;
        }
        if (this.previousRecord != null) {
            this.graphFilter.filter(this.previousRecord);
        }
        boolean checkGraphReady = false;
        this.previousRecord = null;
        do {
            Record record;
            if ((record = this.reader.nextRecord()) == null) {
                this.reader.close();
                return null;
            }
            X9Record x9Record = (X9Record)record;
            switch (x9Record.recordType()) {
                case 25: {
                    checkGraphReady = this.checkGraphReady();
                    break;
                }
                case 70: {
                    checkGraphReady = this.checkGraphReady();
                }
            }
            if (checkGraphReady) {
                this.previousRecord = record;
                continue;
            }
            this.graphFilter.filter(x9Record);
        } while (!checkGraphReady);
        return this.makeGraphCopy(this.graphFilter.checkDetailGraph());
    }

    private X937CheckDetailGraph makeGraphCopy(X937CheckDetailGraph x937CheckDetailGraph) {
        final X937FileHeaderRecord fileHeaderRecord = (X937FileHeaderRecord)x937CheckDetailGraph.fileHeaderRecord().duplicate();
        final X937FileControlRecord fileControlRecord = x937CheckDetailGraph.fileControlRecord() == null ? null : (X937FileControlRecord)x937CheckDetailGraph.fileControlRecord().duplicate();
        final X937CashLetterHeaderRecord cashLetterHeaderRecord = x937CheckDetailGraph.cashLetterHeaderRecord() == null ? null : (X937CashLetterHeaderRecord)x937CheckDetailGraph.cashLetterHeaderRecord().duplicate();
        final X937CashLetterControlRecord cashLetterControlRecord = x937CheckDetailGraph.cashLetterControlRecord() == null ? null : (X937CashLetterControlRecord)x937CheckDetailGraph.cashLetterControlRecord().duplicate();
        final X937BundleHeaderRecord bundleHeaderRecord = x937CheckDetailGraph.bundleHeaderRecord() == null ? null : (X937BundleHeaderRecord)x937CheckDetailGraph.bundleHeaderRecord().duplicate();
        final X937BundleControlRecord bundleControlRecord = x937CheckDetailGraph.bundleControlRecord() == null ? null : (X937BundleControlRecord)x937CheckDetailGraph.bundleControlRecord().duplicate();
        final X937CheckDetailRecord checkDetailRecord = x937CheckDetailGraph.checkDetailRecord();
        final X937CheckDetailAddendumBRecord x937CheckDetailAddendumBRecord = x937CheckDetailGraph.checkDetailAddendumBRecord();
        final ArrayList checkDetailAddendumARecords = Lists.newArrayList(x937CheckDetailGraph.checkDetailAddendumARecords());
        final ArrayList checkDetailAddendumCRecords = Lists.newArrayList(x937CheckDetailGraph.checkDetailAddendumCRecords());
        final ArrayList imageViewRecords = Lists.newArrayList(x937CheckDetailGraph.imageViewRecords());
        return new X937CheckDetailGraph(){

            @Override
            public X937CheckDetailRecord checkDetailRecord() {
                return checkDetailRecord;
            }

            @Override
            public List<X937CheckDetailAddendumARecord> checkDetailAddendumARecords() {
                return checkDetailAddendumARecords;
            }

            @Override
            public X937CheckDetailAddendumBRecord checkDetailAddendumBRecord() {
                return x937CheckDetailAddendumBRecord;
            }

            @Override
            public List<X937CheckDetailAddendumCRecord> checkDetailAddendumCRecords() {
                return checkDetailAddendumCRecords;
            }

            @Override
            public List<X937ImageViewRecords> imageViewRecords() {
                return imageViewRecords;
            }

            @Override
            public X937BundleHeaderRecord bundleHeaderRecord() {
                return bundleHeaderRecord;
            }

            @Override
            public X937BundleControlRecord bundleControlRecord() {
                return bundleControlRecord;
            }

            @Override
            public X937CashLetterHeaderRecord cashLetterHeaderRecord() {
                return cashLetterHeaderRecord;
            }

            @Override
            public X937CashLetterControlRecord cashLetterControlRecord() {
                return cashLetterControlRecord;
            }

            @Override
            public X937FileHeaderRecord fileHeaderRecord() {
                return fileHeaderRecord;
            }

            @Override
            public X937FileControlRecord fileControlRecord() {
                return fileControlRecord;
            }
        };
    }

    private boolean checkGraphReady() {
        X937CheckDetailGraph detailGraph = this.graphFilter.checkDetailGraph();
        X937CheckDetailRecord cdr = detailGraph.checkDetailRecord();
        return cdr != null;
    }

    private X9InputStreamRecordReader createInputStreamReader(InputStream inputStream, boolean skipInvalidRecords) {
        X9InputStreamRecordReader reader = new X9InputStreamRecordReader(inputStream, skipInvalidRecords);
        return reader;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<X937CheckDetailGraph> iterator() {
        return new Iterator<X937CheckDetailGraph>(){

            @Override
            public boolean hasNext() {
                if (X9InputStreamCheckDetailReader.this.cachedRecord != null) {
                    return true;
                }
                try {
                    X9InputStreamCheckDetailReader.this.cachedRecord = X9InputStreamCheckDetailReader.this.readNextCheckDetail();
                    if (X9InputStreamCheckDetailReader.this.cachedRecord == null) {
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new RecordReaderException((Throwable)e);
                }
                return true;
            }

            @Override
            public X937CheckDetailGraph next() {
                X937CheckDetailGraph record = null;
                try {
                    record = X9InputStreamCheckDetailReader.this.readNextCheckDetail();
                }
                catch (Exception e) {
                    throw new RecordReaderException((Throwable)e);
                }
                if (record == null) {
                    throw new NoSuchElementException();
                }
                return record;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

