/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.InputStreamRecordReader;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.exception.InvalidFormatException;
import com.thelastcheck.io.base.exception.InvalidStandardLevelException;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x9.factory.DefaultX9RecordFactoryStrategy;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x9.factory.X9RecordFactoryStrategy;
import com.thelastcheck.io.x937.records.stddstu.X937FileHeaderRecordImpl;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class X9InputStreamRecordReader
extends InputStreamRecordReader {
    private static final String FIRST_BYTE_MUST_BE_AN_ASCII_OR_EBCDIC_0 = "First byte must be an ASCII or EBCDIC '0'";
    private static final String FILE_HEADER_MUST_HAVE_A_RECORD_TYPE_01 = "File Header must have a record type '01'";
    private static final String FILE_HEADER_RECORD_MUST_BE_80_BYTES_IN_LENGTH = "File header record must be 80 bytes in length.";
    private String encoding = "IBM1047";
    private boolean variableLength = false;
    private X9RecordFactoryStrategy factoryStrategy;
    private X9RecordFactory factory;
    private boolean firstTime = true;
    private ByteArray lengthPrefixBuffer = new ByteArray(4);
    private int recordSize;

    public X9InputStreamRecordReader(InputStream inputStream) {
        this(inputStream, null);
    }

    public X9InputStreamRecordReader(InputStream inputStream, boolean skipInvolidRecords) {
        this(inputStream, null, skipInvolidRecords);
    }

    public X9InputStreamRecordReader(InputStream inputStream, X9RecordFactoryStrategy factoryStrategy) {
        this(inputStream, factoryStrategy, false);
    }

    public X9InputStreamRecordReader(InputStream inputStream, X9RecordFactoryStrategy factoryStrategy, boolean skipInvalidRecords) {
        super(inputStream, skipInvalidRecords);
        this.factoryStrategy = factoryStrategy == null ? new DefaultX9RecordFactoryStrategy() : factoryStrategy;
    }

    protected Record readNextRecord() throws IOException {
        ByteArray record;
        int bytesRead;
        if (this.firstTime) {
            this.firstTime = false;
            X9Record x9Record = this.processFirstRecord();
            return x9Record;
        }
        this.recordSize = 80;
        if (this.variableLength) {
            int bytesRead2 = this.read(this.lengthPrefixBuffer);
            if (bytesRead2 < this.lengthPrefixBuffer.getLength()) {
                throw new EOFException("End of stream reached before finished processing expected data.");
            }
            this.recordSize = this.lengthPrefixBuffer.readAsInt(0);
        }
        if ((bytesRead = this.read(record = new ByteArray(this.recordSize, this.encoding))) < this.recordSize) {
            throw new EOFException("End of stream reached before finished processing expected data.");
        }
        X9Record x9Record = this.factory.newX9Record(record);
        return x9Record;
    }

    private X9Record processFirstRecord() throws IOException, InvalidFormatException, InvalidStandardLevelException {
        ByteArray record;
        int bytesRead = this.read(this.lengthPrefixBuffer);
        if (bytesRead < this.lengthPrefixBuffer.getLength()) {
            throw new EOFException("End of stream reached before finished processing expected data.");
        }
        if (this.lengthPrefixBuffer.readAsByte(0) == 0) {
            this.variableLength = true;
            this.recordSize = this.lengthPrefixBuffer.readAsInt(0);
            if (this.recordSize != 80) {
                throw new InvalidFormatException(FILE_HEADER_RECORD_MUST_BE_80_BYTES_IN_LENGTH);
            }
            record = new ByteArray(this.recordSize);
            bytesRead = this.read(record);
            if (bytesRead < this.recordSize) {
                throw new EOFException("End of stream reached before finished processing expected data.");
            }
        } else {
            record = new ByteArray(80);
            record.write(this.lengthPrefixBuffer, 0, 4);
            bytesRead = this.read(record, 4, 76);
            if (bytesRead < 76) {
                throw new EOFException("End of stream reached before finished processing expected data.");
            }
        }
        if ((record.readAsByte(0) & 0xFF) == 240) {
            this.encoding = "IBM1047";
            record.setEncoding(this.encoding);
        } else if ((record.readAsByte(0) & 0xFF) == 48) {
            this.encoding = "US-ASCII";
            record.setEncoding(this.encoding);
        } else {
            throw new InvalidFormatException(FIRST_BYTE_MUST_BE_AN_ASCII_OR_EBCDIC_0);
        }
        X937FileHeaderRecordImpl header = new X937FileHeaderRecordImpl(record, 0);
        int recordType = header.recordType();
        if (recordType != 1) {
            throw new InvalidFormatException(FILE_HEADER_MUST_HAVE_A_RECORD_TYPE_01);
        }
        this.factory = this.factoryStrategy.factory(header);
        return this.factory.newX9Record(record);
    }

    public String getEncoding() {
        return this.encoding;
    }
}

