/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.OutputStreamRecordWriter;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.x9.X9Record;
import java.io.IOException;
import java.io.OutputStream;

public class X9OutputStreamRecordWriter
extends OutputStreamRecordWriter {
    private ByteArray lengthPrefixBuffer = new ByteArray(4);

    public X9OutputStreamRecordWriter(OutputStream os) {
        super(os);
    }

    protected void writeRecord(Record record) throws IOException {
        X9Record x9Record = (X9Record)record;
        if (x9Record.recordStandardLevel() >= 3) {
            int recordLength = x9Record.length();
            this.lengthPrefixBuffer.write(recordLength, 0);
            this.write(this.lengthPrefixBuffer);
        }
        this.write(x9Record.record());
    }
}

