/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.RandomAccessFileRecordReader;
import com.thelastcheck.io.base.exception.InvalidFormatException;
import com.thelastcheck.io.base.exception.InvalidStandardLevelException;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x9.factory.DefaultX9RecordFactoryStrategy;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x9.factory.X9RecordFactoryStrategy;
import com.thelastcheck.io.x937.records.stddstu.X937FileHeaderRecordImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class X9RandomAccessFileRecordReader
extends RandomAccessFileRecordReader {
    private static final String US_ASCII = "US-ASCII";
    private static final String EBCDIC = "IBM1047";
    private static final String END_OF_STREAM_ERROR = "End of stream reached before finished processing expected data.";
    private static final String FIRST_BYTE_MUST_BE_AN_ASCII_OR_EBCDIC_0 = "First byte must be an ASCII or EBCDIC '0'";
    private static final String FILE_HEADER_MUST_HAVE_A_RECORD_TYPE_01 = "File Header must have a record type '01'";
    private static final String FILE_HEADER_RECORD_MUST_BE_80_BYTES_IN_LENGTH = "File header record must be 80 bytes in length.";
    private String encoding = "IBM1047";
    private boolean variableLength = false;
    private X9RecordFactoryStrategy factoryStrategy;
    private X9RecordFactory factory;
    private boolean firstTime = true;
    private ByteArray lengthPrefixBuffer = new ByteArray(4);
    private int recordSize;

    public X9RandomAccessFileRecordReader(File file) throws FileNotFoundException {
        this(file, null);
    }

    public X9RandomAccessFileRecordReader(File file, X9RecordFactoryStrategy factoryStrategy) throws FileNotFoundException {
        super(file);
        this.factoryStrategy = factoryStrategy == null ? new DefaultX9RecordFactoryStrategy() : factoryStrategy;
    }

    public X9Record readRecord(long pos) throws IOException, InvalidFormatException, InvalidDataException, InvalidStandardLevelException {
        ByteArray record;
        int bytesRead;
        if (!this.isStreamAvailable()) {
            this.close();
            return null;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.processFirstRecord();
        }
        this.seek(pos);
        this.recordSize = 80;
        if (this.variableLength) {
            int bytesRead2 = this.read(this.lengthPrefixBuffer);
            if (bytesRead2 < this.lengthPrefixBuffer.getLength()) {
                throw new IOException(END_OF_STREAM_ERROR);
            }
            this.recordSize = this.lengthPrefixBuffer.readAsInt(0);
        }
        if ((bytesRead = this.read(record = new ByteArray(this.recordSize, this.encoding))) < this.recordSize) {
            throw new IOException(END_OF_STREAM_ERROR);
        }
        X9Record x9Record = this.factory.newX9Record(record);
        x9Record.offsetPosition(pos);
        return x9Record;
    }

    private void processFirstRecord() throws IOException, InvalidFormatException, InvalidDataException, InvalidStandardLevelException {
        ByteArray record;
        int bytesRead = this.read(this.lengthPrefixBuffer);
        if (bytesRead < this.lengthPrefixBuffer.getLength()) {
            throw new IOException(END_OF_STREAM_ERROR);
        }
        if (this.lengthPrefixBuffer.readAsByte(0) == 0) {
            this.variableLength = true;
            this.recordSize = this.lengthPrefixBuffer.readAsInt(0);
            if (this.recordSize != 80) {
                throw new InvalidFormatException(FILE_HEADER_RECORD_MUST_BE_80_BYTES_IN_LENGTH);
            }
            record = new ByteArray(this.recordSize);
            bytesRead = this.read(record);
            if (bytesRead < this.recordSize) {
                throw new IOException(END_OF_STREAM_ERROR);
            }
        } else {
            record = new ByteArray(80);
            record.write(this.lengthPrefixBuffer, 0, 4);
            bytesRead = this.read(record, 4, 76);
            if (bytesRead < 76) {
                throw new IOException(END_OF_STREAM_ERROR);
            }
        }
        if ((record.readAsByte(0) & 0xFF) == 240) {
            this.encoding = EBCDIC;
            record.setEncoding(this.encoding);
        } else if ((record.readAsByte(0) & 0xFF) == 48) {
            this.encoding = US_ASCII;
            record.setEncoding(this.encoding);
        } else {
            throw new InvalidFormatException(FIRST_BYTE_MUST_BE_AN_ASCII_OR_EBCDIC_0);
        }
        X937FileHeaderRecordImpl header = new X937FileHeaderRecordImpl(record, 0);
        int recordType = header.recordType();
        if (recordType != 1) {
            throw new InvalidFormatException(FILE_HEADER_MUST_HAVE_A_RECORD_TYPE_01);
        }
        this.factory = this.factoryStrategy.factory(header);
    }

    public String getEncoding() {
        return this.encoding;
    }
}

