/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Field;
import com.thelastcheck.io.base.FieldType;
import com.thelastcheck.io.base.RecordImpl;
import com.thelastcheck.io.x9.X9Record;

public abstract class X9RecordImpl
extends RecordImpl
implements X9Record {
    private int recordType;
    private int recordStandardLevel;
    protected static Field recordTypeField = new Field("RecordType", 1, 0, 2, FieldType.INT);
    private static Field headerStandardLevelField = new Field("standardLevel", 2, 2, 2, FieldType.INT);

    public X9RecordImpl() {
        this(0, "IBM1047", 3);
    }

    public X9RecordImpl(int recordType, int stdLevel) {
        this(recordType, "IBM1047", stdLevel);
    }

    public X9RecordImpl(int recordType, String encoding, int stdLevel) {
        super(80, encoding);
        this.clearRecord();
        this.recordStandardLevel(stdLevel);
        this.recordType(recordType);
    }

    public X9RecordImpl(ByteArray record, int standardLevel) {
        super(record);
        this.initializeRecordType();
        if (this.recordType() == 1) {
            try {
                standardLevel = headerStandardLevelField.extractStringAsInt(record);
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        this.recordStandardLevel(standardLevel);
    }

    public void clearRecord() {
        int recType = this.recordType();
        this.record().fill();
        this.recordType(recType);
    }

    private void initializeRecordType() {
        int recordType = 0;
        try {
            recordType = recordTypeField.extractStringAsInt(this.record());
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.recordType(recordType);
    }

    @Override
    public int recordType() {
        return this.recordType;
    }

    @Override
    public X9Record recordType(int recordType) {
        this.recordType = recordType;
        this.setField(recordType, recordTypeField);
        return this;
    }

    @Override
    public int recordStandardLevel() {
        return this.recordStandardLevel;
    }

    @Override
    public X9Record recordStandardLevel(int recordStandardLevel) {
        this.recordStandardLevel = recordStandardLevel;
        return this;
    }
}

