/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9.factory;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.io.base.exception.InvalidStandardLevelException;
import com.thelastcheck.io.x9.factory.X937RecordFactory1994;
import com.thelastcheck.io.x9.factory.X937RecordFactory2001;
import com.thelastcheck.io.x9.factory.X937RecordFactoryDSTU;
import com.thelastcheck.io.x9.factory.X937RecordFactorySVPCO;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x9.factory.X9RecordFactoryStrategy;
import com.thelastcheck.io.x937.records.X937FileHeaderRecord;

public class DefaultX9RecordFactoryStrategy
implements X9RecordFactoryStrategy {
    @Override
    public X9RecordFactory factory(X937FileHeaderRecord fileHeaderRecord) {
        String standardIdentifier = null;
        int standardLevel = 0;
        try {
            standardLevel = fileHeaderRecord.standardLevelAsInt();
        }
        catch (InvalidDataException e) {
            throw new InvalidStandardLevelException();
        }
        String encoding = fileHeaderRecord.record().getEncoding();
        if (standardLevel == 3) {
            standardIdentifier = "DSTU";
        } else if (standardLevel == 13) {
            standardIdentifier = "SVPCO";
        } else if (standardLevel == 2) {
            standardIdentifier = "2001";
        } else if (standardLevel == 1) {
            standardIdentifier = "1994";
        } else {
            throw new InvalidStandardLevelException();
        }
        X9RecordFactory factory = this.factory(standardIdentifier, encoding);
        return factory;
    }

    @Override
    public X9RecordFactory factory(String standardIdentifier) {
        return this.factory(standardIdentifier, "IBM1047");
    }

    @Override
    public X9RecordFactory factory(String standardIdentifier, String encoding) {
        X9RecordFactory factory = null;
        if (standardIdentifier.equals("DSTU")) {
            factory = new X937RecordFactoryDSTU(encoding);
        } else if (standardIdentifier.equals("SVPCO")) {
            factory = new X937RecordFactorySVPCO(encoding);
        } else if (standardIdentifier.equals("1994")) {
            factory = new X937RecordFactory1994(encoding);
        } else if (standardIdentifier.equals("2001")) {
            factory = new X937RecordFactory2001(encoding);
        } else {
            throw new InvalidStandardLevelException();
        }
        return factory;
    }
}

