/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9.factory;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.exception.InvalidFormatException;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x9.X9RecordImpl;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x937.records.X937FileHeaderRecord;
import com.thelastcheck.io.x937.records.std2001.X937BoxSummaryRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937BundleControlRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937BundleHeaderRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937CashLetterControlRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937CashLetterHeaderRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937CheckDetailAddendumARecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937CheckDetailAddendumBRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937CheckDetailRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937FileControlRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937FileHeaderRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937ReturnAddendumARecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937ReturnAddendumBRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937ReturnAddendumCRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937ReturnRecordImpl;
import com.thelastcheck.io.x937.records.std2001.X937RoutingNumberSummaryRecordImpl;

public class X937RecordFactory2001
implements X9RecordFactory {
    private static final String BAD_RECORD_TYPE_NOT_A_VALID_2_DIGIT_NUMBER = "Bad record type - not a valid 2-digit number";
    private static final String RECORD_TYPE = "Record type [";
    private static final String IS_NOT_A_VALID_X9_37_TYPE = "] is not a valid X9.37 type";
    private static final String RECORD_SIZE_OF = "Record size of [";
    private static final String IS_LESS_THAN_MINIMUM_RECORD_SIZE = "] is less than minimum record size.";
    private int standardLevel = 2;
    private String encoding;

    public X937RecordFactory2001() {
        this.encoding = "IBM1047";
    }

    public X937RecordFactory2001(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Record newX9Record(int recordType) throws InvalidFormatException {
        X9RecordImpl x9Record = null;
        switch (recordType) {
            case 25: {
                x9Record = new X937CheckDetailRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 26: {
                x9Record = new X937CheckDetailAddendumARecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 27: {
                x9Record = new X937CheckDetailAddendumBRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 31: {
                x9Record = new X937ReturnRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 32: {
                x9Record = new X937ReturnAddendumARecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 33: {
                x9Record = new X937ReturnAddendumBRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 34: {
                x9Record = new X937ReturnAddendumCRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 70: {
                x9Record = new X937BundleControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 20: {
                x9Record = new X937BundleHeaderRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 90: {
                x9Record = new X937CashLetterControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 10: {
                x9Record = new X937CashLetterHeaderRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 99: {
                x9Record = new X937FileControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 1: {
                x9Record = new X937FileHeaderRecordImpl(this.encoding, this.standardLevel);
                X937FileHeaderRecord fhr = (X937FileHeaderRecord)((Object)x9Record);
                fhr.standardLevel(this.standardLevel);
                break;
            }
            case 75: {
                x9Record = new X937BoxSummaryRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 85: {
                x9Record = new X937RoutingNumberSummaryRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            default: {
                throw new InvalidFormatException(RECORD_TYPE + recordType + IS_NOT_A_VALID_X9_37_TYPE);
            }
        }
        return x9Record;
    }

    @Override
    public X9Record newX9Record(ByteArray record) throws InvalidFormatException {
        if (record.getLength() < 2) {
            throw new InvalidFormatException(RECORD_SIZE_OF + record.getLength() + IS_LESS_THAN_MINIMUM_RECORD_SIZE);
        }
        X9RecordImpl x9Record = null;
        String recordTypeString = record.readAsString(0, 2, false);
        int recordType = 0;
        try {
            recordType = Integer.parseInt(recordTypeString);
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException(BAD_RECORD_TYPE_NOT_A_VALID_2_DIGIT_NUMBER);
        }
        switch (recordType) {
            case 25: {
                x9Record = new X937CheckDetailRecordImpl(record, this.standardLevel);
                break;
            }
            case 26: {
                x9Record = new X937CheckDetailAddendumARecordImpl(record, this.standardLevel);
                break;
            }
            case 27: {
                x9Record = new X937CheckDetailAddendumBRecordImpl(record, this.standardLevel);
                break;
            }
            case 31: {
                x9Record = new X937ReturnRecordImpl(record, this.standardLevel);
                break;
            }
            case 32: {
                x9Record = new X937ReturnAddendumARecordImpl(record, this.standardLevel);
                break;
            }
            case 33: {
                x9Record = new X937ReturnAddendumBRecordImpl(record, this.standardLevel);
                break;
            }
            case 34: {
                x9Record = new X937ReturnAddendumCRecordImpl(record, this.standardLevel);
                break;
            }
            case 70: {
                x9Record = new X937BundleControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 20: {
                x9Record = new X937BundleHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 90: {
                x9Record = new X937CashLetterControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 10: {
                x9Record = new X937CashLetterHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 99: {
                x9Record = new X937FileControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 1: {
                x9Record = new X937FileHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 75: {
                x9Record = new X937BoxSummaryRecordImpl(record, this.standardLevel);
                break;
            }
            case 85: {
                x9Record = new X937RoutingNumberSummaryRecordImpl(record, this.standardLevel);
                break;
            }
            default: {
                throw new InvalidFormatException(RECORD_TYPE + recordType + IS_NOT_A_VALID_X9_37_TYPE);
            }
        }
        return x9Record;
    }
}

