/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9.factory;

import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Record;
import com.thelastcheck.io.base.exception.InvalidFormatException;
import com.thelastcheck.io.x9.X9Record;
import com.thelastcheck.io.x9.X9RecordImpl;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x937.records.X937CheckDetailAddendumBRecord;
import com.thelastcheck.io.x937.records.X937FileHeaderRecord;
import com.thelastcheck.io.x937.records.X937ImageViewDataRecord;
import com.thelastcheck.io.x937.records.X937ReturnAddendumCRecord;
import com.thelastcheck.io.x937.records.stddstu.X937AccountTotalsDetailRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937BoxSummaryRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937BundleControlRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937BundleHeaderRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CashLetterControlRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CashLetterHeaderRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CheckDetailAddendumARecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CheckDetailAddendumBRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CheckDetailAddendumCRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937CheckDetailRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937FileControlRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937FileHeaderRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ImageViewAnalysisRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ImageViewDataRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ImageViewDetailRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937NonHitTotalsDetailRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ReturnAddendumARecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ReturnAddendumBRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ReturnAddendumCRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ReturnAddendumDRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937ReturnRecordImpl;
import com.thelastcheck.io.x937.records.stddstu.X937RoutingNumberSummaryRecordImpl;

public class X937RecordFactoryDSTU
implements X9RecordFactory {
    private static final String BAD_RECORD_TYPE_NOT_A_VALID_2_DIGIT_NUMBER = "Bad record type - not a valid 2-digit number";
    private static final String RECORD_TYPE = "Record type [";
    private static final String IS_NOT_A_VALID_X9_37_TYPE = "] is not a valid X9.37 type";
    private static final String RECORD_SIZE_OF = "Record size of [";
    private static final String IS_LESS_THAN_MINIMUM_RECORD_SIZE = "] is less than minimum record size.";
    private int standardLevel = 3;
    private String encoding;
    private ByteArray emptyByteArray = new ByteArray(0);

    public X937RecordFactoryDSTU() {
        this.encoding = "IBM1047";
    }

    public X937RecordFactoryDSTU(String encoding) {
        this.encoding = encoding;
    }

    protected void standardLevel(int standardLevel) {
        this.standardLevel = standardLevel;
    }

    @Override
    public Record newX9Record(int recordType) throws InvalidFormatException {
        X9RecordImpl x9Record = null;
        switch (recordType) {
            case 25: {
                x9Record = new X937CheckDetailRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 26: {
                x9Record = new X937CheckDetailAddendumARecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 27: {
                x9Record = new X937CheckDetailAddendumBRecordImpl(this.encoding, this.standardLevel);
                X937CheckDetailAddendumBRecord xcdabr = (X937CheckDetailAddendumBRecord)((Object)x9Record);
                xcdabr.variableSizeRecordIndicator("0");
                break;
            }
            case 28: {
                x9Record = new X937CheckDetailAddendumCRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 31: {
                x9Record = new X937ReturnRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 32: {
                x9Record = new X937ReturnAddendumARecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 33: {
                x9Record = new X937ReturnAddendumBRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 34: {
                x9Record = new X937ReturnAddendumCRecordImpl(this.encoding, this.standardLevel);
                X937ReturnAddendumCRecord xracr = (X937ReturnAddendumCRecord)((Object)x9Record);
                xracr.variableSizeRecordIndicator("0");
                break;
            }
            case 35: {
                x9Record = new X937ReturnAddendumDRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 50: {
                x9Record = new X937ImageViewDetailRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 52: {
                ByteArray newRecord = new ByteArray(117, this.encoding);
                newRecord.fill();
                newRecord.write("52", 0);
                x9Record = new X937ImageViewDataRecordImpl(newRecord, this.standardLevel);
                X937ImageViewDataRecord ivdr = (X937ImageViewDataRecord)((Object)x9Record);
                ivdr.imageReferenceKey("");
                ivdr.digitalSignature(this.emptyByteArray);
                ivdr.imageData(this.emptyByteArray);
                break;
            }
            case 54: {
                x9Record = new X937ImageViewAnalysisRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 70: {
                x9Record = new X937BundleControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 20: {
                x9Record = new X937BundleHeaderRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 90: {
                x9Record = new X937CashLetterControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 10: {
                x9Record = new X937CashLetterHeaderRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 99: {
                x9Record = new X937FileControlRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 1: {
                x9Record = new X937FileHeaderRecordImpl(this.encoding, this.standardLevel);
                X937FileHeaderRecord fhr = (X937FileHeaderRecord)((Object)x9Record);
                fhr.standardLevel(this.standardLevel);
                break;
            }
            case 40: {
                x9Record = new X937AccountTotalsDetailRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 75: {
                x9Record = new X937BoxSummaryRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 41: {
                x9Record = new X937NonHitTotalsDetailRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            case 85: {
                x9Record = new X937RoutingNumberSummaryRecordImpl(this.encoding, this.standardLevel);
                break;
            }
            default: {
                throw new InvalidFormatException(RECORD_TYPE + recordType + IS_NOT_A_VALID_X9_37_TYPE);
            }
        }
        return x9Record;
    }

    @Override
    public X9Record newX9Record(ByteArray record) throws InvalidFormatException {
        if (record.getLength() < 2) {
            throw new InvalidFormatException(RECORD_SIZE_OF + record.getLength() + IS_LESS_THAN_MINIMUM_RECORD_SIZE);
        }
        X9RecordImpl x9Record = null;
        String recordTypeString = record.readAsString(0, 2, false);
        int recordType = 0;
        try {
            recordType = Integer.parseInt(recordTypeString);
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException(BAD_RECORD_TYPE_NOT_A_VALID_2_DIGIT_NUMBER);
        }
        switch (recordType) {
            case 25: {
                x9Record = new X937CheckDetailRecordImpl(record, this.standardLevel);
                break;
            }
            case 26: {
                x9Record = new X937CheckDetailAddendumARecordImpl(record, this.standardLevel);
                break;
            }
            case 27: {
                x9Record = new X937CheckDetailAddendumBRecordImpl(record, this.standardLevel);
                break;
            }
            case 28: {
                x9Record = new X937CheckDetailAddendumCRecordImpl(record, this.standardLevel);
                break;
            }
            case 31: {
                x9Record = new X937ReturnRecordImpl(record, this.standardLevel);
                break;
            }
            case 32: {
                x9Record = new X937ReturnAddendumARecordImpl(record, this.standardLevel);
                break;
            }
            case 33: {
                x9Record = new X937ReturnAddendumBRecordImpl(record, this.standardLevel);
                break;
            }
            case 34: {
                x9Record = new X937ReturnAddendumCRecordImpl(record, this.standardLevel);
                break;
            }
            case 35: {
                x9Record = new X937ReturnAddendumDRecordImpl(record, this.standardLevel);
                break;
            }
            case 50: {
                x9Record = new X937ImageViewDetailRecordImpl(record, this.standardLevel);
                break;
            }
            case 52: {
                x9Record = new X937ImageViewDataRecordImpl(record, this.standardLevel);
                break;
            }
            case 54: {
                x9Record = new X937ImageViewAnalysisRecordImpl(record, this.standardLevel);
                break;
            }
            case 70: {
                x9Record = new X937BundleControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 20: {
                x9Record = new X937BundleHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 90: {
                x9Record = new X937CashLetterControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 10: {
                x9Record = new X937CashLetterHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 99: {
                x9Record = new X937FileControlRecordImpl(record, this.standardLevel);
                break;
            }
            case 1: {
                x9Record = new X937FileHeaderRecordImpl(record, this.standardLevel);
                break;
            }
            case 40: {
                x9Record = new X937AccountTotalsDetailRecordImpl(record, this.standardLevel);
                break;
            }
            case 75: {
                x9Record = new X937BoxSummaryRecordImpl(record, this.standardLevel);
                break;
            }
            case 41: {
                x9Record = new X937NonHitTotalsDetailRecordImpl(record, this.standardLevel);
                break;
            }
            case 85: {
                x9Record = new X937RoutingNumberSummaryRecordImpl(record, this.standardLevel);
                break;
            }
            default: {
                throw new InvalidFormatException(RECORD_TYPE + recordType + IS_NOT_A_VALID_X9_37_TYPE);
            }
        }
        return x9Record;
    }
}

