/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x9.transform;

import com.thelastcheck.commons.base.fields.RoutingNumber;
import com.thelastcheck.io.x9.factory.X9RecordFactory;
import com.thelastcheck.io.x9.transform.X9Transformer;
import com.thelastcheck.io.x937.records.X937CheckDetailRecord;
import com.thelastcheck.io.x937.records.X937ReturnRecord;

public class X937ChecktoReturnTransformer
extends X9Transformer<X937CheckDetailRecord, X937ReturnRecord> {
    private String forwardBundleDate;

    public X937ChecktoReturnTransformer(X9RecordFactory factory, String forwardBundleDate) {
        super(factory);
        this.forwardBundleDate = forwardBundleDate == null ? "" : forwardBundleDate;
    }

    @Override
    public X937ReturnRecord apply(X937CheckDetailRecord checkRecord) {
        X937ReturnRecord record = (X937ReturnRecord)this.factory.newX9Record(31);
        record.externalProcessingCode(checkRecord.externalProcessingCode());
        record.itemAmount(checkRecord.itemAmount());
        record.onUsReturnRecord(checkRecord.onUs());
        record.payorBankRoutingNumber(checkRecord.payorBankRoutingNumber());
        if (checkRecord.payorBankRoutingNumberCheckDigit().equals(" ")) {
            record.payorBankRoutingNumberCheckDigit(RoutingNumber.calculateCheckDigit((String)checkRecord.payorBankRoutingNumberAsString()));
        } else {
            record.payorBankRoutingNumberCheckDigit(checkRecord.payorBankRoutingNumberCheckDigit());
        }
        record.ECEInstitutionItemSequenceNumber(checkRecord.ECEInstitutionItemSequenceNumber());
        record.forwardBundleDate(this.forwardBundleDate);
        record.returnDocumentationTypeIndicator("G");
        record.returnReason(" ");
        record.returnNotificationIndicator("2");
        record.numberOfTimesReturned("0");
        record.returnRecordAddendumCount(0);
        return record;
    }
}

