/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.io.x937.records.stddstu;

import com.thelastcheck.commons.base.exception.InvalidDataException;
import com.thelastcheck.commons.base.fields.RoutingNumber;
import com.thelastcheck.commons.buffer.ByteArray;
import com.thelastcheck.io.base.Field;
import com.thelastcheck.io.base.FieldType;
import com.thelastcheck.io.x937.records.X937ImageViewDataRecord;
import com.thelastcheck.io.x937.records.base.X937ImageViewDataRecordBase;
import java.util.Date;

public class X937ImageViewDataRecordImpl
extends X937ImageViewDataRecordBase {
    private static int maxFieldNumber = 19;
    private static Field[] fields = new Field[maxFieldNumber + 1];
    private Field[] localFieldCache = new Field[maxFieldNumber + 1];

    public X937ImageViewDataRecordImpl() {
    }

    public X937ImageViewDataRecordImpl(int stdLevel) {
        super(stdLevel);
    }

    public X937ImageViewDataRecordImpl(String encoding, int stdLevel) {
        super(encoding, stdLevel);
    }

    public X937ImageViewDataRecordImpl(ByteArray record, int stdLevel) {
        super(record, stdLevel);
    }

    protected void resetDynamicFields() {
        this.localFieldCache[15] = null;
        this.localFieldCache[16] = null;
        this.localFieldCache[17] = null;
        this.localFieldCache[18] = null;
        this.localFieldCache[19] = null;
    }

    public int numberOfFields() {
        return maxFieldNumber;
    }

    protected Field field(int fieldNumber) {
        if (fieldNumber < 1 || fieldNumber > maxFieldNumber) {
            throw new IllegalArgumentException("Invalid Field Number");
        }
        if (this.localFieldCache[fieldNumber] == null) {
            switch (fieldNumber) {
                case 15: {
                    this.localFieldCache[15] = this.calculateFieldImageReferenceKey();
                    break;
                }
                case 16: {
                    this.localFieldCache[16] = this.calculateFieldLengthOfDigitalSignature();
                    break;
                }
                case 17: {
                    this.localFieldCache[17] = this.calculateFieldDigitalSignature();
                    break;
                }
                case 18: {
                    this.localFieldCache[18] = this.calculateFieldLengthOfImageData();
                    break;
                }
                case 19: {
                    this.localFieldCache[19] = this.calculateFieldImageData();
                    break;
                }
                default: {
                    this.localFieldCache[fieldNumber] = fields[fieldNumber];
                }
            }
        }
        return this.localFieldCache[fieldNumber];
    }

    private Field calculateFieldImageReferenceKey() {
        int X = 0;
        try {
            X = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return new Field("ImageReferenceKey", 15, 105, X, FieldType.STRING);
    }

    private Field calculateFieldLengthOfDigitalSignature() {
        int X = 0;
        try {
            X = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return new Field("LengthOfDigitalSignature", 16, 105 + X, 5, FieldType.INT);
    }

    private Field calculateFieldDigitalSignature() {
        int X = 0;
        int Y = 0;
        try {
            X = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        try {
            Y = this.lengthOfDigitalSignatureAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return new Field("DigitalSignature", 17, 110 + X, Y, FieldType.BINARY);
    }

    private Field calculateFieldLengthOfImageData() {
        int X = 0;
        int Y = 0;
        try {
            X = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        try {
            Y = this.lengthOfDigitalSignatureAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        return new Field("LengthOfImageData", 18, 110 + X + Y, 7, FieldType.INT);
    }

    private Field calculateFieldImageData() {
        int X = 0;
        int Y = 0;
        int Z = 0;
        try {
            X = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        try {
            Y = this.lengthOfDigitalSignatureAsInt();
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        try {
            Z = this.lengthOfImageDataAsInt();
        }
        catch (InvalidDataException e) {
            // empty catch block
        }
        return new Field("ImageData", 19, 117 + X + Y, Z, FieldType.BINARY);
    }

    @Override
    public RoutingNumber ECEInstitutionRoutingNumber() {
        return this.getFieldAsRoutingNumber(this.field(2));
    }

    @Override
    public X937ImageViewDataRecord ECEInstitutionRoutingNumber(RoutingNumber value) {
        this.setField(value, this.field(2));
        return this;
    }

    @Override
    public String ECEInstitutionRoutingNumberAsString() {
        return this.getFieldAsString(this.field(2));
    }

    @Override
    public X937ImageViewDataRecord ECEInstitutionRoutingNumber(String value) {
        this.setField(value, this.field(2));
        return this;
    }

    @Override
    public Date bundleBusinessDate() throws InvalidDataException {
        return this.getFieldAsDate(this.field(3), x9TimeZone);
    }

    @Override
    public X937ImageViewDataRecord bundleBusinessDate(Date value) {
        this.setFieldDate(value, this.field(3), x9TimeZone);
        return this;
    }

    @Override
    public String bundleBusinessDateAsString() {
        return this.getFieldAsString(this.field(3));
    }

    @Override
    public X937ImageViewDataRecord bundleBusinessDate(String value) {
        this.setField(value, this.field(3));
        return this;
    }

    @Override
    public String cycleNumber() {
        return this.getFieldAsString(this.field(4));
    }

    @Override
    public X937ImageViewDataRecord cycleNumber(String value) {
        this.setField(value, this.field(4));
        return this;
    }

    @Override
    public String ECEInstitutionItemSequenceNumber() {
        return this.getFieldAsString(this.field(5));
    }

    @Override
    public X937ImageViewDataRecord ECEInstitutionItemSequenceNumber(String value) {
        this.setField(value, this.field(5));
        return this;
    }

    @Override
    public String securityOriginatorName() {
        return this.getFieldAsString(this.field(6));
    }

    @Override
    public X937ImageViewDataRecord securityOriginatorName(String value) {
        this.setField(value, this.field(6));
        return this;
    }

    @Override
    public String securityAuthenticatorName() {
        return this.getFieldAsString(this.field(7));
    }

    @Override
    public X937ImageViewDataRecord securityAuthenticatorName(String value) {
        this.setField(value, this.field(7));
        return this;
    }

    @Override
    public String securityKeyName() {
        return this.getFieldAsString(this.field(8));
    }

    @Override
    public X937ImageViewDataRecord securityKeyName(String value) {
        this.setField(value, this.field(8));
        return this;
    }

    @Override
    public String clippingOrigin() {
        return this.getFieldAsString(this.field(9));
    }

    @Override
    public X937ImageViewDataRecord clippingOrigin(String value) {
        this.setField(value, this.field(9));
        return this;
    }

    @Override
    public String clippingCoordinateH1() {
        return this.getFieldAsString(this.field(10));
    }

    @Override
    public X937ImageViewDataRecord clippingCoordinateH1(String value) {
        this.setField(value, this.field(10));
        return this;
    }

    @Override
    public String clippingCoordinateH2() {
        return this.getFieldAsString(this.field(11));
    }

    @Override
    public X937ImageViewDataRecord clippingCoordinateH2(String value) {
        this.setField(value, this.field(11));
        return this;
    }

    @Override
    public String clippingCoordinateV1() {
        return this.getFieldAsString(this.field(12));
    }

    @Override
    public X937ImageViewDataRecord clippingCoordinateV1(String value) {
        this.setField(value, this.field(12));
        return this;
    }

    @Override
    public String clippingCoordinateV2() {
        return this.getFieldAsString(this.field(13));
    }

    @Override
    public X937ImageViewDataRecord clippingCoordinateV2(String value) {
        this.setField(value, this.field(13));
        return this;
    }

    @Override
    public String lengthOfImageReferenceKey() {
        return this.getFieldAsString(this.field(14));
    }

    private X937ImageViewDataRecord lengthOfImageReferenceKey(String value) {
        this.setField(value, this.field(14));
        return this;
    }

    @Override
    public int lengthOfImageReferenceKeyAsInt() throws InvalidDataException {
        return this.getFieldAsInt(this.field(14));
    }

    private X937ImageViewDataRecord lengthOfImageReferenceKey(int value) {
        this.setField(value, this.field(14));
        return this;
    }

    @Override
    public String imageReferenceKey() {
        return this.getFieldAsString(this.field(15));
    }

    @Override
    public X937ImageViewDataRecord imageReferenceKey(String value) {
        int currentLength = 0;
        try {
            currentLength = this.lengthOfImageReferenceKeyAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        if (currentLength != value.length()) {
            this.allocateNewRecord(currentLength, value.length(), 14, 15);
        }
        this.setField(value, this.field(15));
        this.lengthOfImageReferenceKey(value.length());
        return this;
    }

    @Override
    public String lengthOfDigitalSignature() {
        return this.getFieldAsString(this.field(16));
    }

    private X937ImageViewDataRecord lengthOfDigitalSignature(String value) {
        this.setField(value, this.field(16));
        return this;
    }

    @Override
    public int lengthOfDigitalSignatureAsInt() throws InvalidDataException {
        return this.getFieldAsInt(this.field(16));
    }

    private X937ImageViewDataRecord lengthOfDigitalSignature(int value) {
        this.setField(value, this.field(16));
        return this;
    }

    @Override
    public ByteArray digitalSignature() {
        return this.getFieldAsByteArray(this.field(17));
    }

    @Override
    public X937ImageViewDataRecord digitalSignature(ByteArray value) {
        int currentLength = 0;
        try {
            currentLength = this.lengthOfDigitalSignatureAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        if (currentLength != value.getLength()) {
            this.allocateNewRecord(currentLength, value.getLength(), 16, 17);
        }
        this.setField(value, this.field(17));
        this.lengthOfDigitalSignature(value.getLength());
        return this;
    }

    @Override
    public String lengthOfImageData() {
        return this.getFieldAsString(this.field(18));
    }

    private X937ImageViewDataRecord lengthOfImageData(String value) {
        this.setField(value, this.field(18));
        return this;
    }

    @Override
    public int lengthOfImageDataAsInt() throws InvalidDataException {
        return this.getFieldAsInt(this.field(18));
    }

    private X937ImageViewDataRecord lengthOfImageData(int value) {
        this.setField(value, this.field(18));
        return this;
    }

    @Override
    public ByteArray imageData() {
        return this.getFieldAsByteArray(this.field(19));
    }

    @Override
    public X937ImageViewDataRecord imageData(ByteArray value) {
        int currentLength = 0;
        try {
            currentLength = this.lengthOfImageDataAsInt();
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        if (currentLength != value.getLength()) {
            this.allocateNewRecord(currentLength, value.getLength(), 18, 19);
        }
        this.setField(value, this.field(19));
        this.lengthOfImageData(value.getLength());
        return this;
    }

    static {
        X937ImageViewDataRecordImpl.fields[0] = null;
        X937ImageViewDataRecordImpl.fields[1] = recordTypeField;
        X937ImageViewDataRecordImpl.fields[2] = new Field("ECEInstitutionRoutingNumber", 2, 2, 9, FieldType.ROUTING_NUMBER);
        X937ImageViewDataRecordImpl.fields[3] = new Field("BundleBusinessDate", 3, 11, 8, FieldType.DATE);
        X937ImageViewDataRecordImpl.fields[4] = new Field("CycleNumber", 4, 19, 2, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[5] = new Field("ECEInstitutionItemSequenceNumber", 5, 21, 15, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[6] = new Field("SecurityOriginatorName", 6, 36, 16, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[7] = new Field("SecurityAuthenticatorName", 7, 52, 16, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[8] = new Field("SecurityKeyName", 8, 68, 16, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[9] = new Field("ClippingOrigin", 9, 84, 1, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[10] = new Field("ClippingCoordinateH1", 10, 85, 4, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[11] = new Field("ClippingCoordinateH2", 11, 89, 4, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[12] = new Field("ClippingCoordinateV1", 12, 93, 4, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[13] = new Field("ClippingCoordinateV2", 13, 97, 4, FieldType.STRING);
        X937ImageViewDataRecordImpl.fields[14] = new Field("LengthOfImageReferenceKey", 14, 101, 4, FieldType.INT);
        X937ImageViewDataRecordImpl.fields[15] = null;
        X937ImageViewDataRecordImpl.fields[16] = null;
        X937ImageViewDataRecordImpl.fields[17] = null;
        X937ImageViewDataRecordImpl.fields[18] = null;
        X937ImageViewDataRecordImpl.fields[19] = null;
    }
}

