package com.theokanning.openai.edit;

import com.theokanning.openai.Usage;
import lombok.Data;

import java.util.List;

/**
 * A list of edits generated by OpenAI
 *
 * https://beta.openai.com/docs/api-reference/edits/create
 */
@Data
public class EditResult {

    /**
     * The type of object returned, should be "edit"
     */
    public String object;

    /**
     * The creation time in epoch milliseconds.
     */
    public long created;

    /**
     * A list of generated edits.
     */
    public List<EditChoice> choices;

    /**
     * The API usage for this request
     */
    public Usage usage;
}
