/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.ExecutionMode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="repl", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureReplMojo
extends AbstractClojureCompilerMojo {
    private static final String REPLY_REPLY_MAIN = "reply.ReplyMain";
    @Parameter
    private String replScript;
    private static final Pattern JLINE = Pattern.compile("^.*/jline-[^/]+.jar$");
    private static final Pattern ICLOJURE = Pattern.compile("^.*/iclojure(-[^/]+)?.jar$");
    private static final Pattern REPLY = Pattern.compile("^.*/reply(-[^/]+)?.jar$");

    boolean isJLineAvailable(List<String> elements) {
        return this.isPatternFoundInClasspath(elements, JLINE);
    }

    boolean isIClojureAvailable(List<String> elements) {
        return this.isPatternFoundInClasspath(elements, ICLOJURE);
    }

    boolean isReplyAvailable(List<String> elements) {
        return this.isPatternFoundInClasspath(elements, REPLY);
    }

    private boolean isPatternFoundInClasspath(List<String> elements, Pattern pattern) {
        if (elements != null) {
            for (String e : elements) {
                Matcher m = pattern.matcher(new File(e).toURI().toString());
                if (!m.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void execute() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        String mainClass = "clojure.main";
        if (this.isIClojureAvailable(this.classpathElements)) {
            mainClass = "com.offbytwo.iclojure.Main";
        } else if (this.isReplyAvailable(this.classpathElements)) {
            mainClass = REPLY_REPLY_MAIN;
        } else if (this.isJLineAvailable(this.classpathElements)) {
            this.getLog().info((CharSequence)"Enabling JLine support");
            args.add("clojure.main");
            mainClass = "jline.ConsoleRunner";
        }
        if (this.replScript != null && new File(this.replScript).exists()) {
            args.add("-i");
            args.add(this.replScript);
            if (!mainClass.equals(REPLY_REPLY_MAIN)) {
                args.add("-r");
            }
        }
        this.callClojureWith(ExecutionMode.INTERACTIVE, this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), mainClass, args.toArray(new String[args.size()]));
    }
}

