/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="swank", requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureSwankMojo
extends AbstractClojureCompilerMojo {
    @Parameter
    private String replScript;
    @Parameter(defaultValue="4005", property="clojure.swank.port")
    protected int port;
    @Parameter(defaultValue="2009-09-14", property="clojure.swank.protocolVersion")
    protected String protocolVersion;
    @Parameter(defaultValue="iso-8859-1", property="clojure.swank.encoding")
    protected String encoding;
    @Parameter(defaultValue="localhost", property="clojure.swank.host")
    protected String swankHost;

    public void execute() throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        sb.append("(do ");
        sb.append("(swank.swank/start-server");
        sb.append(" :host \"").append(this.swankHost).append("\"");
        sb.append(" :port ");
        sb.append(Integer.toString(this.port));
        sb.append(" :encoding \"").append(this.encoding).append("\"");
        sb.append(" :dont-close true");
        sb.append("))");
        String swankLoader = sb.toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            swankLoader = this.windowsEscapeCommandLineArg(swankLoader);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.replScript != null && new File(this.replScript).exists()) {
            args.add("-i");
            args.add(this.replScript);
        }
        args.add("-e");
        args.add("(require (quote swank.swank))");
        args.add("-e");
        args.add(swankLoader);
        this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), "clojure.main", args.toArray(new String[args.size()]));
    }

    private String windowsEscapeCommandLineArg(String arg) {
        return "\"" + arg.replace("\"", "\\\"") + "\"";
    }
}

