/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import java.io.File;

public class NamespaceInFile {
    private String namespace;
    private File sourceFile;

    public NamespaceInFile(String namespace, File sourceFile) {
        this.namespace = namespace;
        this.sourceFile = sourceFile;
    }

    public String getName() {
        return this.namespace;
    }

    public String getFilename() {
        String base = this.namespace.replace('.', File.separatorChar).replace('-', '_');
        String sourceName = this.sourceFile.getName();
        String suffix = sourceName.substring(sourceName.lastIndexOf("."));
        return base + suffix;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceInFile that = (NamespaceInFile)o;
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return this.sourceFile.equals(that.sourceFile);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.sourceFile.hashCode();
        return result;
    }
}

