/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.googleformatter;

import com.google.common.base.MoreObjects;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.mockito.Mockito;

@Mojo(name="format", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GoogleFormatterMojo
extends AbstractMojo {
    public static final SuffixMapping SOURCE_MAPPING = new SuffixMapping(".java", new HashSet<String>(Arrays.asList(".java", ".class")));
    @Component
    ScmManager scmManager;
    @Parameter(required=true, readonly=true, property="session")
    protected MavenSession session;
    @Parameter(required=true, readonly=true, property="project")
    protected MavenProject project;
    @Parameter(required=true, readonly=true, property="project.build.sourceDirectory")
    protected File sourceDirectory;
    @Parameter(required=true, readonly=true, property="project.build.testSourceDirectory")
    protected File testSourceDirectory;
    @Parameter(required=true, readonly=true, property="project.build.outputDirectory")
    protected File outputDirectory;
    @Parameter(required=true, readonly=true, property="project.build.testOutputDirectory")
    protected File testOutputDirectory;
    @Parameter(defaultValue="false")
    protected boolean includeStale;
    @Parameter(defaultValue="GOOGLE")
    protected JavaFormatterOptions.Style style;
    @Parameter(defaultValue="false", property="formatter.skip")
    protected boolean skip;
    @Parameter(defaultValue="false", property="formatter.modified")
    protected boolean filterModified;
    @Parameter(defaultValue="false", property="formatter.fixImports")
    protected boolean fixImports;
    @Parameter(defaultValue="100", property="formatter.maxLineLength")
    protected int maxLineLength;

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Project packaging is POM, skipping...");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping source reformatting due to plugin configuration.");
            return;
        }
        try {
            HashSet<File> sourceFiles = new HashSet<File>();
            sourceFiles.addAll(this.findFilesToReformat(this.sourceDirectory, this.outputDirectory));
            sourceFiles.addAll(this.findFilesToReformat(this.testSourceDirectory, this.testOutputDirectory));
            HashSet<File> sourceFilesToProcess = this.filterModified ? this.filterUnchangedFiles(sourceFiles) : sourceFiles;
            JavaFormatterOptions options = this.getJavaFormatterOptions();
            for (File file : sourceFilesToProcess) {
                String source = CharStreams.toString((Readable)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Formatter formatter = new Formatter(options);
                String formattedSource = this.fixImports ? formatter.formatSourceAndFixImports(source) : formatter.formatSource(source);
                HashCode sourceHash = Hashing.sha256().hashString((CharSequence)source, StandardCharsets.UTF_8);
                HashCode formattedHash = Hashing.sha256().hashString((CharSequence)formattedSource, StandardCharsets.UTF_8);
                if (formattedHash.equals((Object)sourceHash)) continue;
                Files.write(file.toPath(), formattedSource.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                this.getLog().info((CharSequence)String.format("Reformatted file %s", file.getPath()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private JavaFormatterOptions getJavaFormatterOptions() {
        JavaFormatterOptions options = (JavaFormatterOptions)Mockito.spy((Object)JavaFormatterOptions.builder().style(this.style).build());
        ((JavaFormatterOptions)Mockito.doReturn((Object)this.maxLineLength).when((Object)options)).maxLineLength();
        return options;
    }

    private Set<File> filterUnchangedFiles(Set<File> originalFiles) throws MojoExecutionException {
        MavenProject topLevelProject = this.session.getTopLevelProject();
        try {
            String connectionUrl = (String)MoreObjects.firstNonNull((Object)topLevelProject.getScm().getConnection(), (Object)topLevelProject.getScm().getDeveloperConnection());
            ScmRepository repository = this.scmManager.makeScmRepository(connectionUrl);
            ScmFileSet scmFileSet = new ScmFileSet(topLevelProject.getBasedir());
            String basePath = topLevelProject.getBasedir().getAbsoluteFile().getPath();
            List changedFiles = this.scmManager.status(repository, scmFileSet).getChangedFiles().stream().map(f -> String.format("%s/%s", basePath, f.getPath())).collect(Collectors.toList());
            return originalFiles.stream().filter(f -> changedFiles.contains(f.getPath())).collect(Collectors.toSet());
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set<File> findFilesToReformat(File sourceDirectory, File outputDirectory) throws MojoExecutionException {
        if (sourceDirectory.exists()) {
            try {
                SourceInclusionScanner scanner = this.getSourceInclusionScanner(this.includeStale);
                scanner.addSourceMapping((SourceMapping)SOURCE_MAPPING);
                Set sourceFiles = scanner.getIncludedSources(sourceDirectory, outputDirectory);
                this.getLog().info((CharSequence)String.format("Found %d uncompiled/modified files in %s to reformat.", sourceFiles.size(), sourceDirectory.getPath()));
                return sourceFiles;
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException(String.format("Error scanning source path: '%s' for  files to reformat.", sourceDirectory.getPath()), (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)String.format("Directory %s does not exist, skipping file collection.", sourceDirectory.getPath()));
        return Collections.emptySet();
    }

    protected SourceInclusionScanner getSourceInclusionScanner(boolean includeStale) {
        return includeStale ? new SimpleSourceInclusionScanner(Collections.singleton("**/*"), Collections.emptySet()) : new StaleSourceScanner(1024L);
    }
}

