/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRepresentationWriter
implements RepresentationWriter<String> {
    public void write(ReadableRepresentation representation, Set<URI> flags, Writer writer) {
        try {
            JsonGenerator g = this.getJsonGenerator(flags, writer);
            g.writeStartObject();
            this.renderJson(flags, g, representation, false);
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    protected JsonGenerator getJsonGenerator(Set<URI> flags, Writer writer) throws IOException {
        JsonGenerator g = this.getJsonFactory(flags).createJsonGenerator(writer);
        if (flags.contains(RepresentationFactory.PRETTY_PRINT)) {
            g.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        }
        return g;
    }

    protected JsonFactory getJsonFactory(Set<URI> flags) {
        JsonFactory f = new JsonFactory();
        ObjectMapper codec = new ObjectMapper();
        if (flags.contains(RepresentationFactory.STRIP_NULLS)) {
            codec.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        codec.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        f.setCodec((ObjectCodec)codec);
        f.enable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        return f;
    }

    private void renderJson(Set<URI> flags, JsonGenerator g, ReadableRepresentation representation, boolean embedded) throws IOException {
        if (!representation.getCanonicalLinks().isEmpty() || !embedded && !representation.getNamespaces().isEmpty()) {
            g.writeObjectFieldStart("_links");
            ArrayList links = Lists.newArrayList();
            if (!embedded) {
                for (Map.Entry entry : representation.getNamespaces().entrySet()) {
                    links.add(new Link(null, "curies", (String)entry.getValue(), (String)entry.getKey(), null, null, null));
                }
            }
            links.addAll(representation.getLinks());
            ImmutableListMultimap linkMap = Multimaps.index((Iterable)links, (Function)new Function<Link, String>(){

                public String apply(@Nullable Link link) {
                    return link.getRel();
                }
            });
            for (Map.Entry linkEntry : linkMap.asMap().entrySet()) {
                if (((Collection)linkEntry.getValue()).size() == 1 && flags.contains(RepresentationFactory.COALESCE_ARRAYS) || ((String)linkEntry.getKey()).equals("self")) {
                    Link link = (Link)((Collection)linkEntry.getValue()).iterator().next();
                    g.writeObjectFieldStart((String)linkEntry.getKey());
                    this.writeJsonLinkContent(g, link);
                    g.writeEndObject();
                    continue;
                }
                g.writeArrayFieldStart((String)linkEntry.getKey());
                for (Link link : (Collection)linkEntry.getValue()) {
                    g.writeStartObject();
                    this.writeJsonLinkContent(g, link);
                    g.writeEndObject();
                }
                g.writeEndArray();
            }
            g.writeEndObject();
        }
        for (Map.Entry entry : representation.getProperties().entrySet()) {
            if (entry.getValue() != null) {
                g.writeObjectField((String)entry.getKey(), entry.getValue());
                continue;
            }
            if (flags.contains(RepresentationFactory.STRIP_NULLS)) continue;
            g.writeNullField((String)entry.getKey());
        }
        if (!representation.getResources().isEmpty()) {
            g.writeObjectFieldStart("_embedded");
            Map resourceMap = representation.getResourceMap();
            for (Map.Entry resourceEntry : resourceMap.entrySet()) {
                if (((Collection)resourceEntry.getValue()).size() == 1 && flags.contains(RepresentationFactory.COALESCE_ARRAYS)) {
                    g.writeObjectFieldStart((String)resourceEntry.getKey());
                    ReadableRepresentation subRepresentation = (ReadableRepresentation)((Collection)resourceEntry.getValue()).iterator().next();
                    this.renderJson(flags, g, subRepresentation, true);
                    g.writeEndObject();
                    continue;
                }
                g.writeArrayFieldStart((String)resourceEntry.getKey());
                for (ReadableRepresentation subRepresentation : (Collection)resourceEntry.getValue()) {
                    g.writeStartObject();
                    this.renderJson(flags, g, subRepresentation, true);
                    g.writeEndObject();
                }
                g.writeEndArray();
            }
            g.writeEndObject();
        }
    }

    private void writeJsonLinkContent(JsonGenerator g, Link link) throws IOException {
        g.writeStringField("href", link.getHref());
        if (!Strings.isNullOrEmpty((String)link.getName())) {
            g.writeStringField("name", link.getName());
        }
        if (!Strings.isNullOrEmpty((String)link.getTitle())) {
            g.writeStringField("title", link.getTitle());
        }
        if (!Strings.isNullOrEmpty((String)link.getHreflang())) {
            g.writeStringField("hreflang", link.getHreflang());
        }
        if (!Strings.isNullOrEmpty((String)link.getProfile())) {
            g.writeStringField("profile", link.getProfile());
        }
        if (link.hasTemplate()) {
            g.writeBooleanField("templated", true);
        }
    }
}

