/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.theoryinpractise.halbuilder.AbstractRepresentationFactory;
import com.theoryinpractise.halbuilder.DefaultRepresentationFactory;
import com.theoryinpractise.halbuilder.api.ContentRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.impl.ContentType;
import com.theoryinpractise.halbuilder.json.JsonRepresentationReader;
import com.theoryinpractise.halbuilder.json.JsonRepresentationWriter;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRepresentationFactory
extends DefaultRepresentationFactory {
    private ObjectMapper mapper;

    public JsonRepresentationFactory() {
        this(null);
    }

    public JsonRepresentationFactory(ObjectMapper mapper) {
        this.withRenderer("application/hal+json", JsonRepresentationWriter.class);
        this.withReader("application/hal+json", JsonRepresentationReader.class);
        this.mapper = mapper;
    }

    public ContentRepresentation readRepresentation(String contentType, Reader reader) {
        if (this.mapper != null && new ContentType(contentType).matches("application/hal+json")) {
            return new JsonRepresentationReader((AbstractRepresentationFactory)this, this.mapper).read(reader);
        }
        return super.readRepresentation(contentType, reader);
    }

    public RepresentationWriter<String> lookupRenderer(String contentType) {
        if (this.mapper != null && new ContentType(contentType).matches("application/hal+json")) {
            return new JsonRepresentationWriter(this.mapper);
        }
        return super.lookupRenderer(contentType);
    }
}

