/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.theoryinpractise.halbuilder.AbstractRepresentationFactory;
import com.theoryinpractise.halbuilder.DefaultRepresentationFactory;
import com.theoryinpractise.halbuilder.api.ContentRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.impl.ContentType;
import com.theoryinpractise.halbuilder.json.JsonRepresentationReader;
import com.theoryinpractise.halbuilder.json.JsonRepresentationWriter;
import java.io.Reader;
import javax.annotation.Nullable;

public class JsonRepresentationFactory
extends DefaultRepresentationFactory {
    @Nullable
    private ObjectMapper mapper;

    public JsonRepresentationFactory() {
        this(null);
    }

    public JsonRepresentationFactory(@Nullable ObjectMapper mapper) {
        this.withRenderer("application/hal+json", JsonRepresentationWriter.class);
        this.withReader("application/hal+json", JsonRepresentationReader.class);
        this.mapper = mapper;
    }

    public ContentRepresentation readRepresentation(String contentType, Reader reader) {
        if (this.mapper != null && new ContentType(contentType).matches("application/hal+json")) {
            return new JsonRepresentationReader((AbstractRepresentationFactory)this, this.mapper).read(reader);
        }
        return super.readRepresentation(contentType, reader);
    }

    public RepresentationWriter<String> lookupRenderer(String contentType) {
        if (this.mapper != null && new ContentType(contentType).matches("application/hal+json")) {
            return new JsonRepresentationWriter(this.mapper);
        }
        return super.lookupRenderer(contentType);
    }
}

