/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.theoryinpractise.halbuilder.AbstractRepresentationFactory;
import com.theoryinpractise.halbuilder.api.ContentRepresentation;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationReader;
import com.theoryinpractise.halbuilder.impl.api.Support;
import com.theoryinpractise.halbuilder.impl.representations.ContentBasedRepresentation;
import com.theoryinpractise.halbuilder.impl.representations.MutableRepresentation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class JsonRepresentationReader
implements RepresentationReader {
    private final ObjectMapper mapper;
    private final AbstractRepresentationFactory representationFactory;

    public JsonRepresentationReader(AbstractRepresentationFactory representationFactory) {
        this(representationFactory, new ObjectMapper());
    }

    public JsonRepresentationReader(AbstractRepresentationFactory representationFactory, ObjectMapper mapper) {
        this.representationFactory = representationFactory;
        this.mapper = mapper;
    }

    public ContentRepresentation read(Reader reader) {
        try {
            String source = CharStreams.toString((Readable)reader);
            JsonNode rootNode = (JsonNode)this.mapper.readValue((Reader)new StringReader(source), JsonNode.class);
            return this.readResource(rootNode);
        }
        catch (Exception e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private ContentRepresentation readResource(JsonNode rootNode) throws IOException {
        ContentBasedRepresentation resource = new ContentBasedRepresentation(this.representationFactory, rootNode.toString());
        this.readNamespaces((MutableRepresentation)resource, rootNode);
        this.readLinks((MutableRepresentation)resource, rootNode);
        this.readProperties((MutableRepresentation)resource, rootNode);
        this.readResources((MutableRepresentation)resource, rootNode);
        return resource;
    }

    private void readNamespaces(MutableRepresentation resource, JsonNode rootNode) {
        JsonNode linksNode;
        if (rootNode.has("_links") && (linksNode = rootNode.get("_links")).has("curies")) {
            JsonNode curieNode = linksNode.get("curies");
            if (curieNode.isArray()) {
                Iterator values = curieNode.elements();
                while (values.hasNext()) {
                    JsonNode valueNode = (JsonNode)values.next();
                    resource.withNamespace(valueNode.get("name").asText(), valueNode.get("href").asText());
                }
            } else {
                resource.withNamespace(curieNode.get("name").asText(), curieNode.get("href").asText());
            }
        }
    }

    private void readLinks(MutableRepresentation resource, JsonNode rootNode) {
        if (rootNode.has("_links")) {
            Iterator fields = rootNode.get("_links").fields();
            while (fields.hasNext()) {
                Map.Entry keyNode = (Map.Entry)fields.next();
                if ("curies".equals(keyNode.getKey())) continue;
                if (((JsonNode)keyNode.getValue()).isArray()) {
                    Iterator values = ((JsonNode)keyNode.getValue()).elements();
                    while (values.hasNext()) {
                        JsonNode valueNode = (JsonNode)values.next();
                        this.withJsonLink(resource, keyNode, valueNode);
                    }
                    continue;
                }
                this.withJsonLink(resource, keyNode, (JsonNode)keyNode.getValue());
            }
        }
    }

    private void withJsonLink(MutableRepresentation resource, Map.Entry<String, JsonNode> keyNode, JsonNode valueNode) {
        String rel = keyNode.getKey();
        String href = valueNode.get("href").asText();
        String name = this.optionalNodeValueAsText(valueNode, "name");
        String title = this.optionalNodeValueAsText(valueNode, "title");
        String hreflang = this.optionalNodeValueAsText(valueNode, "hreflang");
        String profile = this.optionalNodeValueAsText(valueNode, "profile");
        resource.withLink(rel, href, name, title, hreflang, profile);
    }

    String optionalNodeValueAsText(JsonNode node, String key) {
        JsonNode value = node.get(key);
        return value != null ? value.asText() : "";
    }

    private void readProperties(MutableRepresentation resource, JsonNode rootNode) throws IOException {
        Iterator fieldNames = rootNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if (Support.RESERVED_JSON_PROPERTIES.contains(fieldName)) continue;
            JsonNode field = rootNode.get(fieldName);
            if (field.isArray()) {
                ArrayList<String> arrayValues = new ArrayList<String>(field.size());
                for (JsonNode arrayValue : field) {
                    arrayValues.add(!arrayValue.isContainerNode() ? arrayValue.asText() : ImmutableMap.copyOf((Map)((Map)this.mapper.readValue(arrayValue.toString(), Map.class))));
                }
                resource.withProperty(fieldName, arrayValues);
                continue;
            }
            resource.withProperty(fieldName, field.isNull() ? null : (!field.isContainerNode() ? field.asText() : ImmutableMap.copyOf((Map)((Map)this.mapper.readValue(field.toString(), Map.class)))));
        }
    }

    private void readResources(MutableRepresentation resource, JsonNode rootNode) throws IOException {
        if (rootNode.has("_embedded")) {
            Iterator fields = rootNode.get("_embedded").fields();
            while (fields.hasNext()) {
                Map.Entry keyNode = (Map.Entry)fields.next();
                if (((JsonNode)keyNode.getValue()).isArray()) {
                    Iterator values = ((JsonNode)keyNode.getValue()).elements();
                    while (values.hasNext()) {
                        JsonNode valueNode = (JsonNode)values.next();
                        resource.withRepresentation((String)keyNode.getKey(), (ReadableRepresentation)this.readResource(valueNode));
                    }
                    continue;
                }
                resource.withRepresentation((String)keyNode.getKey(), (ReadableRepresentation)this.readResource((JsonNode)keyNode.getValue()));
            }
        }
    }
}

