/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.xml;

import com.theoryinpractise.halbuilder.AbstractRepresentationFactory;
import com.theoryinpractise.halbuilder.api.ContentRepresentation;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationReader;
import com.theoryinpractise.halbuilder.impl.representations.ContentBasedRepresentation;
import com.theoryinpractise.halbuilder.xml.XmlRepresentationFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class XmlRepresentationReader
implements RepresentationReader {
    private AbstractRepresentationFactory representationFactory;
    private XMLOutputter xmlOutputter;

    public XmlRepresentationReader(AbstractRepresentationFactory representationFactory) {
        this.representationFactory = representationFactory;
        this.xmlOutputter = new XMLOutputter();
    }

    public ContentRepresentation read(Reader reader) {
        try {
            Document d = new SAXBuilder().build(reader);
            Element root = d.getRootElement();
            return this.readRepresentation(root);
        }
        catch (JDOMException e) {
            throw new RepresentationException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private ContentRepresentation readRepresentation(Element root) {
        String href = root.getAttributeValue("href");
        ContentBasedRepresentation resource = new ContentBasedRepresentation(this.representationFactory, this.xmlOutputter.outputString(root), href);
        this.readNamespaces((Representation)resource, root);
        this.readLinks((Representation)resource, root);
        this.readProperties((Representation)resource, root);
        this.readResources((Representation)resource, root);
        return resource;
    }

    private void readNamespaces(Representation resource, Element element) {
        List namespaces = element.getAdditionalNamespaces();
        for (Namespace ns : namespaces) {
            if ("xsi".equals(ns.getPrefix())) continue;
            resource.withNamespace(ns.getPrefix(), ns.getURI());
        }
    }

    private void readLinks(Representation resource, Element element) {
        List links = element.getChildren("link");
        for (Element link : links) {
            String rel = link.getAttributeValue("rel");
            String href = link.getAttributeValue("href");
            String name = link.getAttributeValue("name");
            String title = link.getAttributeValue("title");
            String hreflang = link.getAttributeValue("hreflang");
            String profile = link.getAttributeValue("profile");
            resource.withLink(rel, href, name, title, hreflang, profile);
        }
    }

    private void readProperties(Representation resource, Element element) {
        List properties = element.getChildren();
        for (Element property : properties) {
            if (property.getName().matches("(link|resource)")) continue;
            if (property.getAttribute("nil", XmlRepresentationFactory.XSI_NAMESPACE) != null) {
                resource.withProperty(property.getName(), null);
                continue;
            }
            resource.withProperty(property.getName(), (Object)property.getValue());
        }
    }

    private void readResources(Representation halResource, Element element) {
        List resources = element.getChildren("resource");
        for (Element resource : resources) {
            String rel = resource.getAttributeValue("rel");
            ContentRepresentation subResource = this.readRepresentation(resource);
            halResource.withRepresentation(rel, (ReadableRepresentation)subResource);
        }
    }
}

