/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.halbuilder.xml;

import com.google.common.base.Strings;
import com.theoryinpractise.halbuilder.api.Link;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.RepresentationException;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.api.RepresentationWriter;
import com.theoryinpractise.halbuilder.xml.XmlRepresentationFactory;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlRepresentationWriter
implements RepresentationWriter<String> {
    public void write(ReadableRepresentation representation, Set<URI> flags, Writer writer) {
        Element element = this.renderElement("self", representation, false);
        try {
            Format prettyFormat = flags.contains(RepresentationFactory.PRETTY_PRINT) ? Format.getPrettyFormat() : Format.getCompactFormat();
            XMLOutputter outputter = new XMLOutputter(prettyFormat);
            outputter.output(element, writer);
        }
        catch (IOException e) {
            throw new RepresentationException((Throwable)e);
        }
    }

    private Element renderElement(String rel, ReadableRepresentation representation, boolean embedded) {
        Link resourceLink = representation.getResourceLink();
        Element resourceElement = new Element("resource");
        if (resourceLink != null) {
            resourceElement.setAttribute("href", resourceLink.getHref());
        }
        if (!"self".equals(rel)) {
            resourceElement.setAttribute("rel", rel);
        }
        if (!embedded) {
            for (Map.Entry entry : representation.getNamespaces().entrySet()) {
                resourceElement.addNamespaceDeclaration(Namespace.getNamespace((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
            if (representation.hasNullProperties()) {
                resourceElement.addNamespaceDeclaration(XmlRepresentationFactory.XSI_NAMESPACE);
            }
        }
        List links = representation.getLinks();
        for (Link link : links) {
            Element linkElement = new Element("link");
            if (link.getRel().equals("self")) continue;
            linkElement.setAttribute("rel", link.getRel());
            linkElement.setAttribute("href", link.getHref());
            if (!Strings.isNullOrEmpty((String)link.getName())) {
                linkElement.setAttribute("name", link.getName());
            }
            if (!Strings.isNullOrEmpty((String)link.getTitle())) {
                linkElement.setAttribute("title", link.getTitle());
            }
            if (!Strings.isNullOrEmpty((String)link.getHreflang())) {
                linkElement.setAttribute("hreflang", link.getHreflang());
            }
            if (!Strings.isNullOrEmpty((String)link.getProfile())) {
                linkElement.setAttribute("profile", link.getProfile());
            }
            if (link.hasTemplate()) {
                linkElement.setAttribute("templated", "true");
            }
            resourceElement.addContent((Content)linkElement);
        }
        for (Map.Entry entry : representation.getProperties().entrySet()) {
            Element propertyElement = new Element((String)entry.getKey());
            if (entry.getValue() != null) {
                propertyElement.setContent((Content)new Text(entry.getValue().toString()));
            } else {
                propertyElement.setAttribute("nil", "true", XmlRepresentationFactory.XSI_NAMESPACE);
            }
            resourceElement.addContent((Content)propertyElement);
        }
        for (Map.Entry entry : representation.getResources()) {
            Element subResourceElement = this.renderElement((String)entry.getKey(), (ReadableRepresentation)entry.getValue(), true);
            resourceElement.addContent((Content)subResourceElement);
        }
        return resourceElement;
    }
}

