/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;

public class AwsClientHelpers {
    static AWSCredentialsProvider getCredentialsProvider(final String accessKey, final String secretKey) {
        Object credProvider = null != accessKey && null != secretKey ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new BasicAWSCredentials(accessKey, secretKey);
            }

            public void refresh() {
            }
        }, new DefaultAWSCredentialsProviderChain()}) : new DefaultAWSCredentialsProviderChain();
        return credProvider;
    }

    static AwsClientBuilder getS3ClientBuilder() {
        return AmazonS3ClientBuilder.standard();
    }

    public static AmazonS3 buildClient(String accessKey, String secretKey, Region region, String serviceEndpoint, String signingRegion) {
        AWSCredentialsProvider credentialsProvider = AwsClientHelpers.getCredentialsProvider(accessKey, secretKey);
        AwsClientBuilder builder = AwsClientHelpers.getS3ClientBuilder();
        builder = builder.withCredentials(credentialsProvider);
        if (region != null) {
            builder = builder.withRegion(region.getName());
        }
        if (serviceEndpoint != null) {
            builder = builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(serviceEndpoint, signingRegion));
        }
        return (AmazonS3)builder.build();
    }
}

