/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;

public class S3Configuration {
    public static final String DEFAULT_LOG_BUCKETPATH = "logs/";
    private String accessKey = null;
    private String secretKey = null;
    private Region region = null;
    private String bucket = null;
    private String path = "logs/";
    private String serviceEndpoint = null;
    private String signingRegion = null;
    private S3SSEConfiguration sseConfiguration = null;

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Region getRegion() {
        return this.region;
    }

    public S3SSEConfiguration getSseConfiguration() {
        return this.sseConfiguration;
    }

    public void setSseConfiguration(S3SSEConfiguration sseConfiguration) {
        this.sseConfiguration = sseConfiguration;
    }

    public void setRegion(String regionName) {
        this.region = S3Configuration.resolveRegion(regionName);
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public String getSigningRegion() {
        return this.signingRegion;
    }

    public void setSigningRegion(String signingRegion) {
        this.signingRegion = signingRegion;
    }

    static Region resolveRegion(String str) {
        Region region = null;
        if (null != str && str.length() > 0) {
            Regions regions;
            try {
                regions = Regions.valueOf((String)str);
            }
            catch (IllegalArgumentException ex) {
                regions = Regions.fromName((String)str);
            }
            region = Region.getRegion((Regions)regions);
        }
        return region;
    }

    public static final class S3SSEConfiguration {
        private final SSEType keyType;
        private final String keyId;

        public S3SSEConfiguration(SSEType keyType, String keyId) {
            if (keyType != SSEType.SSE_S3) {
                throw new UnsupportedOperationException("Only SSE_S3 is supported at this time.");
            }
            this.keyType = keyType;
            this.keyId = keyId;
        }

        public SSEType getKeyType() {
            return this.keyType;
        }

        public String getKeyId() {
            return this.keyId;
        }
    }

    public static enum SSEType {
        SSE_S3,
        SSE_KMS,
        SSE_C;

    }
}

