/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.van.logging.Event;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import com.van.logging.aws.S3Configuration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.http.entity.ContentType;

public class S3PublishHelper
implements IPublishHelper<Event> {
    private final AmazonS3Client client;
    private final String bucket;
    private final String path;
    private boolean compressEnabled = false;
    private final S3Configuration.S3SSEConfiguration sseConfig;
    private volatile boolean bucketExists = false;
    private File tempFile;
    private Writer outputWriter;

    public S3PublishHelper(AmazonS3Client client, String bucket, String path, boolean compressEnabled, S3Configuration.S3SSEConfiguration sseConfig) {
        this.client = client;
        this.bucket = bucket.toLowerCase();
        this.path = !path.endsWith("/") ? path + "/" : path;
        this.compressEnabled = compressEnabled;
        this.sseConfig = sseConfig;
    }

    @Override
    public void start(PublishContext context) {
        try {
            this.tempFile = File.createTempFile("s3Publish", null);
            OutputStream os = S3PublishHelper.createCompressedStreamAsNecessary(new BufferedOutputStream(new FileOutputStream(this.tempFile)), this.compressEnabled);
            this.outputWriter = new OutputStreamWriter(os);
            if (!this.bucketExists) {
                this.bucketExists = this.client.doesBucketExist(this.bucket);
                if (!this.bucketExists) {
                    this.client.createBucket(this.bucket);
                    this.bucketExists = true;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Cannot start publishing: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        try {
            this.outputWriter.write(event.getMessage());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Cannot collect event %s: %s", event, ex.getMessage()), ex);
        }
    }

    @Override
    public void end(PublishContext context) {
        String key = String.format("%s%s", this.path, context.getCacheName());
        try {
            if (null != this.outputWriter) {
                this.outputWriter.close();
                this.outputWriter = null;
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(this.tempFile.length());
                metadata.setContentType(ContentType.DEFAULT_BINARY.getMimeType());
                if (this.sseConfig != null && this.sseConfig.getKeyType() == S3Configuration.SSEType.SSE_S3) {
                    metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                }
                PutObjectRequest por = new PutObjectRequest(this.bucket, key, this.tempFile);
                por.setMetadata(metadata);
                PutObjectResult putObjectResult = this.client.putObject(por);
            }
        }
        catch (UnsupportedEncodingException metadata) {
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Cannot publish to S3: %s", ex.getMessage()), ex);
        }
        finally {
            if (null != this.tempFile) {
                try {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    static OutputStream createCompressedStreamAsNecessary(OutputStream outputStream, boolean compressEnabled) throws IOException {
        Objects.requireNonNull(outputStream);
        if (compressEnabled) {
            return new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }
}

