/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.IBufferMonitor;
import com.van.logging.IBufferPublisher;
import com.van.logging.IFlushAndPublish;
import com.van.logging.PublishContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class LoggingEventCache<T>
implements IFlushAndPublish {
    public static final String PUBLISH_THREAD_NAME = "LoggingEventCache-publish-thread";
    private static final String DEFAULT_TEMP_FILE_PREFIX = "log4j-s3";
    private final String cacheName;
    private File tempBufferFile;
    private final Object bufferLock = new Object();
    private AtomicReference<ObjectOutputStream> objectOutputStreamRef = new AtomicReference();
    private AtomicInteger eventCount = new AtomicInteger();
    private final IBufferMonitor<T> cacheMonitor;
    private final IBufferPublisher<T> cachePublisher;
    private final ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEventCache(String cacheName, IBufferMonitor<T> cacheMonitor, IBufferPublisher<T> cachePublisher) throws Exception {
        this.cacheName = null == cacheName ? DEFAULT_TEMP_FILE_PREFIX : cacheName;
        this.cacheMonitor = cacheMonitor;
        this.cachePublisher = cachePublisher;
        Object object = this.bufferLock;
        synchronized (object) {
            this.tempBufferFile = File.createTempFile(this.cacheName, null);
            this.objectOutputStreamRef.set(new ObjectOutputStream(new FileOutputStream(this.tempBufferFile)));
            this.eventCount.set(0);
        }
        this.executorService = this.createExecutorService();
    }

    ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(1);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T event) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.objectOutputStreamRef.get().writeObject(event);
            this.eventCount.incrementAndGet();
        }
        this.cacheMonitor.eventAdded(event, this);
    }

    @Override
    public Future<Boolean> flushAndPublish() {
        Future<Boolean> f = null;
        if (this.eventCount.get() > 0) {
            f = this.publishCache(this.cacheName);
        }
        return f;
    }

    Future<Boolean> publishCache(String name) {
        return this.executorService.submit(() -> {
            boolean success = true;
            try {
                Thread.currentThread().setName(PUBLISH_THREAD_NAME);
                PublishContext context = this.cachePublisher.startPublish(this.cacheName);
                int count = 0;
                File tempFile = null;
                Object object = this.bufferLock;
                synchronized (object) {
                    this.objectOutputStreamRef.get().close();
                    tempFile = this.tempBufferFile;
                    count = this.eventCount.get();
                    this.tempBufferFile = File.createTempFile(this.cacheName, null);
                    this.objectOutputStreamRef.set(new ObjectOutputStream(new FileOutputStream(this.tempBufferFile)));
                    this.eventCount.set(0);
                }
                try (FileInputStream fis = new FileInputStream(tempFile);
                     ObjectInputStream ois = new ObjectInputStream(fis);){
                    for (int i = 0; i < count; ++i) {
                        this.cachePublisher.publish(context, count, ois.readObject());
                    }
                    this.cachePublisher.endPublish(context);
                }
                finally {
                    try {
                        tempFile.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable t) {
                System.err.println(String.format("Error while publishing cache: %s", t.getMessage()));
                t.printStackTrace();
            }
            return success;
        });
    }
}

