/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.van.logging.AbstractFilePublishHelper;
import com.van.logging.PublishContext;
import com.van.logging.azure.BlobConfiguration;
import java.io.File;

public class BlobPublishHelper
extends AbstractFilePublishHelper {
    private final BlobConfiguration blobConfiguration;

    public BlobPublishHelper(BlobConfiguration blobConfiguration, boolean verbose) {
        super(blobConfiguration.isCompressionEnabled(), verbose);
        this.blobConfiguration = blobConfiguration;
    }

    @Override
    protected void publishFile(File file, PublishContext context) throws Exception {
        String connectionString = this.blobConfiguration.getStorageConnectionString();
        if (null == connectionString || connectionString.isEmpty()) {
            connectionString = System.getenv("AZURE_STORAGE_CONNECTION_STRING");
        }
        CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)connectionString);
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        CloudBlobContainer container = blobClient.getContainerReference(this.blobConfiguration.getContainerName());
        boolean created = container.createIfNotExists(BlobContainerPublicAccessType.CONTAINER, new BlobRequestOptions(), new OperationContext());
        String prefix = "";
        if (null != this.blobConfiguration.getBlobNamePrefix()) {
            prefix = this.blobConfiguration.getBlobNamePrefix();
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        String blobName = String.format("%s%s", prefix, context.getCacheName());
        if (this.verbose) {
            System.out.println(String.format("Publishing %s to Azure blob (container=%s; blob=%s):", file.getAbsolutePath(), this.blobConfiguration.getContainerName(), blobName));
        }
        CloudBlockBlob blob = container.getBlockBlobReference(blobName);
        if (this.blobConfiguration.isCompressionEnabled()) {
            blob.getProperties().setContentType("application/gzip");
        } else {
            blob.getProperties().setContentType("text/plain");
        }
        blob.uploadFromFile(file.getAbsolutePath());
        if (this.verbose) {
            System.out.println(String.format("Publishing to Azure blob %s done.", blobName));
        }
    }
}

