/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.elasticsearch;

import java.util.LinkedList;
import java.util.List;

public class ElasticsearchConfiguration {
    private static final String DEFAULT_CLUSTERNAME = "elasticsearch";
    private static final String DEFAULT_INDEX = "logindex";
    private static final String DEFAULT_TYPE = "log";
    private String clusterName = "elasticsearch";
    private String index = "logindex";
    private String type = "log";
    private final List<String> hosts = new LinkedList<String>();

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addHost(String host) {
        this.hosts.add(host);
    }

    public void iterateHosts(IHostConsumer consumer) {
        for (String host : this.hosts) {
            String[] parts = host.split(":");
            int port = 9300;
            String hostName = parts[0].trim();
            try {
                port = Integer.parseInt(parts[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            consumer.consume(hostName, port);
        }
    }

    public String toString() {
        return String.format("ElasticsearchConfiguration: cluster=%s, hosts=%s, index=%s, type=%s", this.clusterName, this.hosts.toString(), this.index, this.type);
    }

    public static interface IHostConsumer {
        public void consume(String var1, int var2);
    }
}

