/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.IBufferMonitor;
import com.van.logging.IBufferPublisher;
import com.van.logging.IFlushAndPublish;
import com.van.logging.PublishContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class LoggingEventCache<T>
implements IFlushAndPublish {
    public static final String PUBLISH_THREAD_NAME = "LoggingEventCache-publish-thread";
    private static final int PUBLISHING_THREADS = 1;
    private static final long SHUTDOWN_TIMEOUT_SECS = 10L;
    private static final String DEFAULT_TEMP_FILE_PREFIX = "log4j-s3";
    private final String cacheName;
    private File tempBufferFile;
    private final Object bufferLock = new Object();
    private final AtomicReference<ObjectOutputStream> objectOutputStreamRef = new AtomicReference();
    private final AtomicInteger eventCount = new AtomicInteger();
    private final IBufferMonitor<T> cacheMonitor;
    private final IBufferPublisher<T> cachePublisher;
    private final AtomicReference<ExecutorService> executorServiceRef = new AtomicReference<Object>(null);
    private static final Queue<LoggingEventCache> instances = new ConcurrentLinkedQueue<LoggingEventCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutDown() throws InterruptedException {
        boolean success = true;
        LoggingEventCache instance = instances.poll();
        while (null != instance) {
            try {
                ExecutorService executorService = instance.executorServiceRef.getAndSet(null);
                if (null != executorService) {
                    System.out.println(String.format("LoggingEventCache %s: shutting down", instance));
                    executorService.shutdown();
                    boolean terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
                    System.out.println(String.format("LoggingEventCache: Executor service terminated within timeout: %s", terminated));
                    success &= terminated;
                }
                if (null == instance.cacheMonitor) continue;
                instance.cacheMonitor.shutDown();
            }
            catch (Exception ex) {
                System.err.println(String.format("LoggingEventCache: error shutting down %s\n", instance));
            }
            finally {
                instance = instances.poll();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEventCache(String cacheName, IBufferMonitor<T> cacheMonitor, IBufferPublisher<T> cachePublisher) throws Exception {
        this.cacheName = null == cacheName ? DEFAULT_TEMP_FILE_PREFIX : cacheName;
        this.cacheMonitor = cacheMonitor;
        this.cachePublisher = cachePublisher;
        Object object = this.bufferLock;
        synchronized (object) {
            this.tempBufferFile = File.createTempFile(this.cacheName, null);
            this.objectOutputStreamRef.set(new ObjectOutputStream(new FileOutputStream(this.tempBufferFile)));
            this.eventCount.set(0);
        }
        this.executorServiceRef.set(this.createExecutorService());
        instances.add(this);
    }

    ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(1);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T event) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.objectOutputStreamRef.get().writeObject(event);
            this.eventCount.incrementAndGet();
        }
        this.cacheMonitor.eventAdded(event, this);
    }

    @Override
    public Future<Boolean> flushAndPublish(boolean useCurrentThread) {
        Future<Boolean> f = null;
        if (this.eventCount.get() > 0) {
            f = this.publishCache(this.cacheName, useCurrentThread);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishEventsFromFile(AtomicReference<File> fileToPublishRef, AtomicInteger eventCount) {
        try {
            PublishContext context = this.cachePublisher.startPublish(this.cacheName);
            File fileToPublish = fileToPublishRef.get();
            try (FileInputStream fis = new FileInputStream(fileToPublish);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                for (int i = 0; i < eventCount.get(); ++i) {
                    this.cachePublisher.publish(context, i, ois.readObject());
                }
                this.cachePublisher.endPublish(context);
            }
            finally {
                try {
                    fileToPublish.delete();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            System.err.println(String.format("Error while publishing cache from publishing thread: %s", t.getMessage()));
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Boolean> publishCache(String name, boolean useCurrentThread) {
        boolean success;
        block8: {
            AtomicReference<File> fileToPublishRef = new AtomicReference<File>();
            AtomicInteger eventCountInPublishFile = new AtomicInteger();
            success = true;
            try {
                Object object = this.bufferLock;
                synchronized (object) {
                    this.objectOutputStreamRef.get().close();
                    fileToPublishRef.set(this.tempBufferFile);
                    eventCountInPublishFile.set(this.eventCount.get());
                    this.tempBufferFile = File.createTempFile(this.cacheName, null);
                    this.objectOutputStreamRef.set(new ObjectOutputStream(new FileOutputStream(this.tempBufferFile)));
                    this.eventCount.set(0);
                }
                if (useCurrentThread) {
                    this.publishEventsFromFile(fileToPublishRef, eventCountInPublishFile);
                    break block8;
                }
                LoggingEventCache me = this;
                ExecutorService executorService = this.executorServiceRef.get();
                if (null != executorService) {
                    executorService.submit(() -> {
                        Thread.currentThread().setName(PUBLISH_THREAD_NAME);
                        me.publishEventsFromFile(fileToPublishRef, eventCountInPublishFile);
                    });
                    break block8;
                }
                throw new RejectedExecutionException("executorServiceRef has null ref.");
            }
            catch (RejectedExecutionException ex) {
                System.err.println("ExecutorService refused submitted task. Was shutDown() called?");
            }
            catch (Throwable t) {
                System.err.println(String.format("Error while publishing cache: %s", t.getMessage()));
                t.printStackTrace();
                success = false;
            }
        }
        return CompletableFuture.completedFuture(success);
    }
}

