/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.IBufferMonitor;
import com.van.logging.IFlushAndPublish;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TimePeriodBasedBufferMonitor<T>
implements IBufferMonitor<T> {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final AtomicBoolean monitorStarted = new AtomicBoolean(false);
    private final long periodInSeconds;

    public TimePeriodBasedBufferMonitor(int minutes) {
        this(minutes, TimeUnit.MINUTES);
    }

    public TimePeriodBasedBufferMonitor(int amount, TimeUnit timeUnit) {
        this.periodInSeconds = timeUnit.toSeconds(amount);
    }

    @Override
    public void eventAdded(T event, final IFlushAndPublish publisher) {
        if (!this.monitorStarted.getAndSet(true)) {
            TimeDurationTuple tuple = this.getSchedulingTimeDuration();
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long started = System.currentTimeMillis();
                    Thread.currentThread().setName("TimePeriodBasedBufferMonitor-publish-trigger");
                    try {
                        publisher.flushAndPublish();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        long now = System.currentTimeMillis();
                        if (now - started > TimePeriodBasedBufferMonitor.this.periodInSeconds * 9L / 10L) {
                            System.err.println("Publish operation is approaching monitor period. Increase period or risk compromising fixed rate.");
                        }
                    }
                }
            }, 0L, tuple.amount, tuple.timeUnit);
        }
    }

    @Override
    public void shutDown() {
        System.out.println("TimePeriodBasedBufferMonitor: shutting down.");
        this.scheduledExecutorService.shutdownNow();
    }

    public String toString() {
        return String.format("TimePeriodBasedBufferMonitor(periodInSeconds: %d)", this.periodInSeconds);
    }

    TimeDurationTuple getSchedulingTimeDuration() {
        return new TimeDurationTuple(this.periodInSeconds, TimeUnit.SECONDS);
    }

    static class TimeDurationTuple {
        public final long amount;
        public final TimeUnit timeUnit;

        public TimeDurationTuple(long amount, TimeUnit timeUnit) {
            this.amount = amount;
            this.timeUnit = timeUnit;
        }

        public String toString() {
            return String.format("TimeDurationTuple(%d,%s)", this.amount, this.timeUnit.name());
        }
    }
}

