/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.van.logging.AbstractFilePublishHelper;
import com.van.logging.IStorageDestinationAdjuster;
import com.van.logging.PublishContext;
import com.van.logging.aws.AwsClientHelpers;
import com.van.logging.aws.S3Configuration;
import com.van.logging.utils.PublishHelperUtils;
import com.van.logging.utils.StringUtils;
import java.io.File;
import org.apache.http.entity.ContentType;

public class S3PublishHelper
extends AbstractFilePublishHelper {
    private final AmazonS3Client client;
    private final String bucket;
    private final String path;
    private final S3Configuration.S3SSEConfiguration sseConfig;
    private final CannedAccessControlList cannedAcl;
    private final IStorageDestinationAdjuster storageDestinationAdjuster;
    private volatile boolean bucketExists = false;

    public S3PublishHelper(S3Configuration s3, IStorageDestinationAdjuster storageDestinationAdjuster, boolean verbose) {
        super(s3.isCompressionEnabled(), verbose);
        this.client = (AmazonS3Client)AwsClientHelpers.buildClient(s3.getAccessKey(), s3.getSecretKey(), s3.getSessionToken(), s3.getRegion(), s3.getServiceEndpoint(), s3.getSigningRegion());
        this.bucket = s3.getBucket().toLowerCase();
        this.storageDestinationAdjuster = storageDestinationAdjuster;
        this.path = s3.getPath();
        this.sseConfig = s3.getSseConfiguration();
        this.cannedAcl = s3.getCannedAcl();
    }

    @Override
    public void start(PublishContext context) {
        super.start(context);
        try {
            if (!this.bucketExists) {
                this.bucketExists = this.client.doesBucketExist(this.bucket);
                if (!this.bucketExists) {
                    this.client.createBucket(this.bucket);
                    this.bucketExists = true;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Cannot start publishing: %s", ex.getMessage()), ex);
        }
    }

    @Override
    protected void publishFile(File file, PublishContext context) {
        String path = StringUtils.addTrailingIfNeeded(PublishHelperUtils.adjustStoragePathIfNecessary(this.path, this.storageDestinationAdjuster), "/");
        String key = String.format("%s%s", path, context.getCacheName());
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(file.length());
            metadata.setContentType(ContentType.DEFAULT_BINARY.getMimeType());
            if (this.sseConfig != null && this.sseConfig.getKeyType() == S3Configuration.SSEType.SSE_S3) {
                metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            }
            PutObjectRequest por = this.cannedAcl != null ? new PutObjectRequest(this.bucket, key, file).withCannedAcl(this.cannedAcl) : new PutObjectRequest(this.bucket, key, file);
            por.setMetadata(metadata);
            PutObjectResult putObjectResult = this.client.putObject(por);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Cannot publish to S3: %s", ex.getMessage()), ex);
        }
    }
}

