/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.elasticsearch;

import com.van.logging.Event;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import com.van.logging.elasticsearch.ElasticsearchConfiguration;
import java.net.InetAddress;
import java.util.Date;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class ElasticsearchPublishHelper
implements IPublishHelper<Event> {
    private final ElasticsearchConfiguration configuration;
    private TransportClient transport;
    private BulkRequestBuilder builder;
    private int offset;
    private Date timeStamp;

    public ElasticsearchPublishHelper(ElasticsearchConfiguration configuration) {
        this.configuration = configuration;
    }

    private TransportClient getTransportClient(ElasticsearchConfiguration config) {
        Settings settings = Settings.builder().put("cluster.name", config.getClusterName()).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        config.iterateHosts((host, port) -> {
            try {
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host), port));
            }
            catch (Exception e) {
                System.err.println(String.format("Cannot add Elasticsearch host %s(%d): %s", host, port, e.getMessage()));
            }
        });
        return client;
    }

    @Override
    public void start(PublishContext context) {
        this.offset = 0;
        this.timeStamp = new Date();
        this.transport = this.getTransportClient(this.configuration);
        this.builder = this.transport.prepareBulk();
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        try {
            String id = String.format("%s-%s-%016d", context.getCacheName(), context.getHostName(), this.offset);
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder().startObject().field("timestamp", this.timeStamp).field("type", event.getType()).field("hostname", context.getHostName()).field("offset", this.offset).field("thread_name", event.getThreadName()).field("logger", event.getSource()).field("message", event.getMessage()).array("tags", context.getTags()).endObject();
            this.builder.add(this.transport.prepareIndex(this.configuration.getIndex(), this.configuration.getType(), id).setSource(contentBuilder));
            ++this.offset;
        }
        catch (Exception ex) {
            System.err.println(String.format("Cannot publish event: %s", ex.getMessage()));
        }
    }

    @Override
    public void end(PublishContext context) {
        try {
            BulkResponse response;
            if (null != this.builder && (response = (BulkResponse)this.builder.get()).hasFailures()) {
                System.err.println("Elasticsearch publish failures: " + response.buildFailureMessage());
            }
        }
        finally {
            this.builder = null;
            this.transport.close();
            this.transport = null;
        }
    }
}

