/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.van.logging.utils.StringUtils;

public class S3Configuration {
    private String accessKey = null;
    private String secretKey = null;
    private String sessionToken = null;
    private Region region = null;
    private String bucket = null;
    private String path = null;
    private String serviceEndpoint = null;
    private String signingRegion = null;
    private boolean pathStyleAccess = false;
    private boolean compressionEnabled = false;
    private boolean keyGzSuffixEnabled = false;
    private S3SSEConfiguration sseConfiguration = null;
    private CannedAccessControlList cannedAcl = null;

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public Region getRegion() {
        return this.region;
    }

    public S3SSEConfiguration getSseConfiguration() {
        return this.sseConfiguration;
    }

    public void setSseConfiguration(S3SSEConfiguration sseConfiguration) {
        this.sseConfiguration = sseConfiguration;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public void setCannedAclFromValue(String cannedAclValue) throws IllegalArgumentException {
        this.cannedAcl = CannedAccessControlList.valueOf((String)cannedAclValue);
    }

    public void setRegion(String regionName) {
        this.region = S3Configuration.resolveRegion(regionName);
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public String getSigningRegion() {
        return this.signingRegion;
    }

    public void setSigningRegion(String signingRegion) {
        this.signingRegion = signingRegion;
    }

    public void setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public boolean isKeyGzSuffixEnabled() {
        return this.keyGzSuffixEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public void setKeyGzSuffixEnabled(boolean gzSuffix) {
        this.keyGzSuffixEnabled = gzSuffix;
    }

    static Region resolveRegion(String str) {
        Region region = null;
        if (StringUtils.isTruthy(str)) {
            Regions regions;
            try {
                regions = Regions.valueOf((String)str);
            }
            catch (IllegalArgumentException ex) {
                regions = Regions.fromName((String)str);
            }
            region = Region.getRegion((Regions)regions);
        }
        return region;
    }

    public String toString() {
        if (StringUtils.isTruthy(this.path)) {
            return String.format("S3 configuration (%s:%s in region %s; compressed: %s)", this.bucket, this.path, this.region, this.compressionEnabled);
        }
        return String.format("S3 configuration (%s in region %s; compressed: %s)", this.bucket, this.region, this.compressionEnabled);
    }

    public static final class S3SSEConfiguration {
        private final SSEType keyType;
        private final String keyId;

        public S3SSEConfiguration(SSEType keyType, String keyId) {
            if (keyType != SSEType.SSE_S3) {
                throw new UnsupportedOperationException("Only SSE_S3 is supported at this time.");
            }
            this.keyType = keyType;
            this.keyId = keyId;
        }

        public SSEType getKeyType() {
            return this.keyType;
        }

        public String getKeyId() {
            return this.keyId;
        }
    }

    public static enum SSEType {
        SSE_S3,
        SSE_KMS,
        SSE_C;

    }
}

