/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.elasticsearch;

import com.van.logging.Event;
import com.van.logging.PublishContext;
import com.van.logging.elasticsearch.ElasticsearchConfiguration;
import com.van.logging.elasticsearch.IElasticsearchPublishHelper;
import com.van.logging.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpHost;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticsearchPublishHelper
implements IElasticsearchPublishHelper {
    private ElasticsearchConfiguration configuration;
    private final List<Node> nodes = new ArrayList<Node>();
    private RestHighLevelClient client;
    private BulkRequest bulkRequest;
    private int offset;
    private Date timeStamp;

    @Override
    public void initialize(ElasticsearchConfiguration configuration) {
        this.configuration = configuration;
        this.configuration.iterateHosts((host, port) -> this.nodes.add(this.createNodeFromHost(host, port)));
    }

    Node createNodeFromHost(String host, int port) {
        String[] schemeAndHostname;
        String scheme = null;
        String hostName = host.toLowerCase().trim();
        if ((hostName.startsWith("http:") || hostName.startsWith("https:")) && (schemeAndHostname = hostName.split(":")).length >= 2) {
            scheme = schemeAndHostname[0];
            hostName = schemeAndHostname[1];
        }
        return new Node(new HttpHost(hostName, port, scheme));
    }

    @Override
    public void start(PublishContext context) {
        this.offset = 0;
        this.timeStamp = new Date();
        try {
            Method restClientBuilderMethod = RestClient.class.getDeclaredMethod("builder", Node[].class);
            restClientBuilderMethod.setAccessible(true);
            RestClientBuilder builder = (RestClientBuilder)restClientBuilderMethod.invoke(null, new Object[]{this.nodes.toArray(new Node[0])});
            this.client = new RestHighLevelClient(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bulkRequest = new BulkRequest();
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        try {
            String id = String.format("%s-%s-%016d", context.getCacheName(), context.getHostName(), this.offset);
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder().startObject().field("timestamp", (Object)this.timeStamp).field("type", event.getType()).field("hostname", context.getHostName()).field("offset", this.offset).field("thread_name", event.getThreadName()).field("logger", event.getSource()).field("message", event.getMessage()).array("tags", context.getTags()).endObject();
            this.bulkRequest.add(new IndexRequest(this.configuration.getIndex()).id(id).source(contentBuilder));
            ++this.offset;
        }
        catch (Exception ex) {
            System.err.printf("Cannot publish event: %s%n", ex.getMessage());
        }
    }

    @Override
    public void end(PublishContext context) {
        try {
            BulkResponse response;
            if (null != this.client && null != this.bulkRequest && (response = this.client.bulk(this.bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                System.err.println("Elasticsearch publish failures: " + response.buildFailureMessage());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (null != this.client) {
                    this.client.close();
                }
                this.bulkRequest = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static IElasticsearchPublishHelper getPublishHelper(String publishHelperNameSpec, ClassLoader classLoader) {
        ElasticsearchPublishHelper helper = null;
        if (StringUtils.isTruthy(publishHelperNameSpec)) {
            System.out.printf("Attempting to instantiate %s%n", publishHelperNameSpec);
            try {
                Class<?> cls = classLoader.loadClass(publishHelperNameSpec);
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                helper = (ElasticsearchPublishHelper)ctor.newInstance(new Object[0]);
                System.out.printf("Successfully registered %s as Elasticsearch publish helper%n", publishHelperNameSpec);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (null == helper) {
            System.out.printf("Instantiating the default ElasticsearchPublishHelper%n", new Object[0]);
            helper = new ElasticsearchPublishHelper();
        }
        return helper;
    }
}

