/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.gcp;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.van.logging.AbstractFilePublishHelper;
import com.van.logging.IStorageDestinationAdjuster;
import com.van.logging.PublishContext;
import com.van.logging.gcp.CloudStorageConfiguration;
import com.van.logging.utils.PublishHelperUtils;
import com.van.logging.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class CloudStoragePublishHelper
extends AbstractFilePublishHelper {
    private final CloudStorageConfiguration configuration;
    private final IStorageDestinationAdjuster storageDestinationAdjuster;

    public CloudStoragePublishHelper(CloudStorageConfiguration configuration, IStorageDestinationAdjuster storageDestinationAdjuster, boolean verbose) {
        super(configuration.isCompressionEnabled(), verbose);
        this.configuration = configuration;
        this.storageDestinationAdjuster = storageDestinationAdjuster;
    }

    static String getBlobName(PublishContext context, String path, CloudStorageConfiguration configuration) {
        String blobName = String.format("%s%s", path, context.getCacheName());
        if (configuration.isCompressionEnabled() && configuration.isBlobNameGzSuffixEnabled()) {
            blobName = String.format("%s.gz", blobName);
        }
        return blobName;
    }

    @Override
    protected void publishFile(File file, PublishContext context) throws Exception {
        String bucketName = this.configuration.getBucketName();
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
        if (null == bucket) {
            bucket = storage.create(BucketInfo.of((String)bucketName), new Storage.BucketTargetOption[0]);
        }
        String path = StringUtils.addTrailingIfNeeded(PublishHelperUtils.adjustStoragePathIfNecessary(this.configuration.getBlobNamePrefix(), this.storageDestinationAdjuster), "/");
        String blobName = CloudStoragePublishHelper.getBlobName(context, path, this.configuration);
        if (this.verbose) {
            System.out.println(String.format("Publishing %s to GCS blob (bucket=%s; blob=%s):", file.getAbsolutePath(), bucketName, blobName));
        }
        BlobId blobId = BlobId.of((String)bucketName, (String)blobName);
        String contentType = this.configuration.isCompressionEnabled() ? "application/gzip" : "text/plain";
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType(contentType).build();
        this.uploadToStorage(storage, file, blobInfo);
    }

    private void uploadToStorage(Storage storage, File uploadFrom, BlobInfo blobInfo) throws IOException {
        if (uploadFrom.length() < 1000000L) {
            storage.create(blobInfo, Files.readAllBytes(uploadFrom.toPath()), new Storage.BlobTargetOption[0]);
        } else {
            try (WriteChannel writer = storage.writer(blobInfo, new Storage.BlobWriteOption[0]);){
                byte[] buffer = new byte[10240];
                try (InputStream input = Files.newInputStream(uploadFrom.toPath(), new OpenOption[0]);){
                    int limit;
                    while ((limit = input.read(buffer)) >= 0) {
                        writer.write(ByteBuffer.wrap(buffer, 0, limit));
                    }
                }
            }
        }
    }
}

