/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.IBufferPublisher;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class BufferPublisher<T>
implements IBufferPublisher<T> {
    private final String hostName;
    private final String[] tags;
    private List<IPublishHelper<T>> helpers = new LinkedList<IPublishHelper<T>>();

    public BufferPublisher(String hostName, String[] tags) {
        this.hostName = hostName;
        this.tags = tags;
    }

    @Override
    public PublishContext startPublish(String cacheName) {
        String namespacedCacheName = this.composeNamespacedCacheName(cacheName);
        PublishContext context = new PublishContext(namespacedCacheName, this.hostName, this.tags);
        for (IPublishHelper<T> helper : this.helpers) {
            try {
                helper.start(context);
            }
            catch (Throwable t) {
                System.err.println(String.format("Cannot start publish with %s due to error: %s", helper, t.getMessage()));
            }
        }
        return context;
    }

    String composeNamespacedCacheName(String rawCacheName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return String.format("%s_%s_%s", df.format(new Date()), this.hostName, rawCacheName);
    }

    @Override
    public void publish(PublishContext context, int sequence, T event) {
        for (IPublishHelper<T> helper : this.helpers) {
            try {
                helper.publish(context, sequence, event);
            }
            catch (Throwable t) {
                System.err.println(String.format("Cannot publish with %s due to error: %s", helper, t.getMessage()));
            }
        }
    }

    @Override
    public void endPublish(PublishContext context) {
        for (IPublishHelper<T> helper : this.helpers) {
            try {
                helper.end(context);
            }
            catch (Throwable t) {
                System.err.println(String.format("Cannot end publish with %s due to error: %s", helper, t.getMessage()));
            }
        }
    }

    public void addHelper(IPublishHelper<T> helper) {
        this.helpers.add(helper);
    }
}

