/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.van.logging.utils.StringUtils;

public class AwsClientHelpers {
    static AWSCredentialsProvider getCredentialsProvider(String accessKey, String secretKey, String sessionToken) {
        DefaultAWSCredentialsProviderChain credProvider;
        if (null != accessKey && null != secretKey) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(accessKey, secretKey);
            if (sessionToken != null) {
                credentials = new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            }
            BasicAWSCredentials finalCredentials = credentials;
            credProvider = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new AWSCredentialsProvider((AWSCredentials)finalCredentials){
                final /* synthetic */ AWSCredentials val$finalCredentials;
                {
                    this.val$finalCredentials = aWSCredentials;
                }

                public AWSCredentials getCredentials() {
                    return this.val$finalCredentials;
                }

                public void refresh() {
                }
            }, new DefaultAWSCredentialsProviderChain()});
        } else {
            credProvider = new DefaultAWSCredentialsProviderChain();
        }
        return credProvider;
    }

    static AmazonS3ClientBuilder getS3ClientBuilder() {
        return AmazonS3ClientBuilder.standard();
    }

    public static AmazonS3 buildClient(String accessKey, String secretKey, String sessionToken, Region region, String serviceEndpoint, String signingRegion, boolean pathStyleAccess) {
        AWSCredentialsProvider credentialsProvider = AwsClientHelpers.getCredentialsProvider(accessKey, secretKey, sessionToken);
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AwsClientHelpers.getS3ClientBuilder().withCredentials(credentialsProvider)).withPathStyleAccessEnabled(Boolean.valueOf(pathStyleAccess));
        if (region != null) {
            builder = (AmazonS3ClientBuilder)builder.withRegion(region.getName());
        }
        if (StringUtils.isTruthy(serviceEndpoint)) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(serviceEndpoint, signingRegion));
        }
        return (AmazonS3)builder.build();
    }
}

