/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging.elasticsearch;

import com.van.logging.utils.StringUtils;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.HttpHost;

public class ElasticsearchConfiguration {
    private static final String DEFAULT_CLUSTERNAME = "elasticsearch";
    private static final String DEFAULT_INDEX = "logindex";
    private static final String DEFAULT_TYPE = "_doc";
    private String clusterName = "elasticsearch";
    private String index = "logindex";
    private String type = "_doc";
    private final List<String> hosts = new LinkedList<String>();

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addHost(String host) {
        this.hosts.add(host);
    }

    public Stream<HttpHost> getHttpHosts() {
        return this.hosts.stream().map(hostString -> {
            block7: {
                int port = 9300;
                String hostName = null;
                String scheme = null;
                try {
                    if (!StringUtils.isTruthy(hostString)) break block7;
                    if (hostString.startsWith("http://") || hostString.startsWith("https://")) {
                        URL parsedUrl = new URL((String)hostString);
                        hostName = parsedUrl.getHost();
                        port = parsedUrl.getPort();
                        if (port < 0) {
                            port = 9300;
                        }
                        scheme = parsedUrl.getProtocol();
                    } else {
                        String[] parts = hostString.split(":");
                        hostName = parts[0].trim();
                        try {
                            port = Integer.parseInt(parts[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return new HttpHost(hostName, port, scheme);
                }
                catch (Exception ex) {
                    System.err.println(String.format("Cannot parse host %s: %s", hostString, ex));
                }
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public String toString() {
        return String.format("ElasticsearchConfiguration: cluster=%s, hosts=%s, index=%s, type=%s", this.clusterName, this.hosts.toString(), this.index, this.type);
    }
}

