/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.Event;
import com.van.logging.IPublishHelper;
import com.van.logging.PublishContext;
import com.van.logging.VansLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractFilePublishHelper
implements IPublishHelper {
    private final boolean compressEnabled;
    protected final boolean verbose;
    private File tempFile;
    private Writer outputWriter;

    public AbstractFilePublishHelper(boolean compressEnabled, boolean verbose) {
        this.compressEnabled = compressEnabled;
        this.verbose = verbose;
    }

    @Override
    public void start(PublishContext context) {
        try {
            this.tempFile = File.createTempFile("toBePublished", null);
            OutputStream os = AbstractFilePublishHelper.createCompressedStreamAsNecessary(new BufferedOutputStream(new FileOutputStream(this.tempFile)), this.compressEnabled, this.verbose);
            this.outputWriter = new OutputStreamWriter(os);
            if (this.verbose) {
                VansLogger.logger.debug(String.format("Collecting content into %s before uploading.", this.tempFile));
            }
        }
        catch (Exception ex) {
            if (this.verbose) {
                VansLogger.logger.error("Cannot start publish batch", (Throwable)ex);
            }
            throw new RuntimeException(String.format("Cannot start publishing: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public void publish(PublishContext context, int sequence, Event event) {
        try {
            this.outputWriter.write(event.getMessage());
        }
        catch (Exception ex) {
            if (this.verbose) {
                VansLogger.logger.error("Cannot publish batch", (Throwable)ex);
            }
            throw new RuntimeException(String.format("Cannot collect event %s: %s", event, ex.getMessage()), ex);
        }
    }

    @Override
    public void end(PublishContext context) {
        try {
            if (null != this.outputWriter) {
                this.outputWriter.close();
                this.outputWriter = null;
            }
            this.publishFile(this.tempFile, context);
        }
        catch (Exception ex) {
            if (this.verbose) {
                VansLogger.logger.error("Cannot end publish batch", (Throwable)ex);
            }
            throw new RuntimeException(String.format("Cannot end publishing: %s", ex.getMessage()), ex);
        }
        finally {
            if (null != this.tempFile) {
                try {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    protected abstract void publishFile(File var1, PublishContext var2) throws Exception;

    static OutputStream createCompressedStreamAsNecessary(OutputStream outputStream, boolean compressEnabled, boolean verbose) throws IOException {
        Objects.requireNonNull(outputStream);
        if (compressEnabled) {
            if (verbose) {
                VansLogger.logger.debug("Content will be compressed.");
            }
            return new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }
}

