/*
 * Decompiled with CFR 0.152.
 */
package com.van.logging;

import com.van.logging.Event;
import com.van.logging.IBufferMonitor;
import com.van.logging.IFlushAndPublish;
import com.van.logging.VansLogger;

public class CapacityBasedBufferMonitor
implements IBufferMonitor {
    private final int cacheLimit;
    private final Object countGuard = new Object();
    private int count = 0;
    private boolean verbose = false;

    public CapacityBasedBufferMonitor(int cacheLimit) {
        this(cacheLimit, false);
    }

    public CapacityBasedBufferMonitor(int cacheLimit, boolean verbose) {
        this.cacheLimit = cacheLimit;
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventAdded(Event event, IFlushAndPublish cache) {
        boolean flush = false;
        Object object = this.countGuard;
        synchronized (object) {
            if (++this.count >= this.cacheLimit) {
                flush = true;
                this.count = 0;
            }
        }
        if (flush) {
            try {
                cache.flushAndPublish();
            }
            catch (Exception ex) {
                VansLogger.logger.error("Cannot flush and publish", (Throwable)ex);
            }
        }
    }

    @Override
    public void shutDown() {
        if (this.verbose) {
            VansLogger.logger.info("CapacityBasedBufferMonitor: shutting down.");
        }
    }

    public String toString() {
        return String.format("CapacityBasedBufferMonitor(cacheLimit: %d)", this.cacheLimit);
    }
}

